import React from 'react';
import UsageMeter from '../../finance/UsageMeter';
import { Search } from 'lucide-react';

const UsageLimitsPage: React.FC = () => {
    // Mock Data mimicking a selected user view
    const mockUserStats = [
        { feature_slug: 'api_calls', count: 850, limit: 1000, reset_at: '2024-03-01' },
        { feature_slug: 'property_listings', count: 2, limit: 5, reset_at: '2024-03-01' },
        { feature_slug: 'storage_gb', count: 4.5, limit: 10, reset_at: '2024-03-01' },
    ];

    return (
        <div className="p-6 space-y-6 bg-gray-50 min-h-screen">
            <div className="flex justify-between items-center mb-6">
                <div>
                    <h1 className="text-2xl font-bold text-gray-900">Usage Limits & Monitoring</h1>
                    <p className="text-sm text-gray-500">Monitor user consumption and manage quotas.</p>
                </div>
            </div>

            <div className="bg-white p-4 rounded-xl shadow-sm border border-gray-100 mb-6 flex items-center gap-4">
                <label className="text-sm font-medium text-gray-700">Simulate User View:</label>
                <div className="relative max-w-sm flex-1">
                    <Search className="absolute left-3 top-1/2 -translate-y-1/2 w-4 h-4 text-gray-400" />
                    <input
                        type="text"
                        placeholder="Enter User Email or ID..."
                        className="w-full pl-10 pr-4 py-2 rounded-lg border border-gray-200 focus:outline-none focus:ring-2 focus:ring-[#0056D2]/20 text-sm"
                        defaultValue="john.doe@example.com"
                    />
                </div>
            </div>

            <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
                {mockUserStats.map((stat) => (
                    <UsageMeter
                        key={stat.feature_slug}
                        stats={stat}
                        onUpgrade={() => console.log('Edit Limit Clicked')}
                    />
                ))}
            </div>
        </div>
    );
};

export default UsageLimitsPage;
