import React from 'react';
import { AlertTriangle, X } from 'lucide-react';
import { Button } from '../ui/button';
import { getImpersonationInfo, restoreAdminSession } from '../../api/impersonation';

export const ImpersonationBanner: React.FC = () => {
  const impersonationInfo = getImpersonationInfo();

  if (!impersonationInfo) {
    return null;
  }

  const handleRestore = () => {
    if (window.confirm('Are you sure you want to restore your admin session?')) {
      restoreAdminSession();
    }
  };

  return (
    <div className="bg-white border-b border-gray-200 px-4 py-3 shadow-sm sticky top-0 z-[100]">
      <div className="container mx-auto flex items-center justify-between relative min-h-[40px]">
        {/* Centered Text */}
        <div className="absolute left-1/2 top-1/2 transform -translate-x-1/2 -translate-y-1/2 w-full text-center pointer-events-none">
          <span className="font-bold text-black text-lg">
            {impersonationInfo.originalRole} &rarr; {impersonationInfo.role}
          </span>
        </div>

        {/* Right Side Button */}
        <div className="flex items-center gap-4 ml-auto z-10">
          <Button
            onClick={handleRestore}
            className="bg-[#0056D2] hover:bg-[#0056D2]/90 text-white border-none shadow-md"
            size="sm"
          >
            <X className="mr-2 h-4 w-4" />
            Restore Admin Session
          </Button>
        </div>
      </div>
    </div>
  );
};
