import React, { useState } from "react";
import {
  TrendingUp,
  BarChart3,
  PieChart,
  CheckCircle,
  Activity,
} from "lucide-react";

import PlatformOverview from "./market-analysis/PlatformOverview";
import CityTrends from "./market-analysis/CityTrends";
import DemandSupplyAnalysis from "./market-analysis/DemandSupplyAnalysis";
import MarketShifts from "./market-analysis/MarketShifts";
import DataQuality from "./market-analysis/DataQuality";

const MarketAnalysis: React.FC = () => {
  const [activeTab, setActiveTab] = useState("overview");

  const tabs = [
    { id: "overview", label: "Platform Overview", icon: Activity },
    { id: "city-trends", label: "City Trends", icon: TrendingUp },
    { id: "demand-supply", label: "Demand-Supply", icon: BarChart3 },
    { id: "market-shifts", label: "Market Shifts", icon: PieChart },
    { id: "data-quality", label: "Data Quality", icon: CheckCircle },
  ];

  const renderActiveComponent = () => {
    switch (activeTab) {
      case "overview":
        return <PlatformOverview />;
      case "city-trends":
        return <CityTrends />;
      case "demand-supply":
        return <DemandSupplyAnalysis />;
      case "market-shifts":
        return <MarketShifts />;
      case "data-quality":
        return <DataQuality />;
      default:
        return <PlatformOverview />;
    }
  };

  return (
    <div className="p-6 bg-gray-50 min-h-screen">
      <div className="mb-6">
        <h1 className="text-3xl font-bold text-gray-900 mb-2">
          Market Analysis
        </h1>
        <p className="text-gray-600">
          Comprehensive market insights and analytics dashboard
        </p>
      </div>

      {/* Tabs */}
      <div className="bg-white rounded-lg shadow-sm mb-6">
        <div className="border-b border-gray-200">
          <nav className="flex space-x-8 px-6">
            {tabs.map((tab) => {
              const Icon = tab.icon;
              return (
                <button
                  key={tab.id}
                  onClick={() => setActiveTab(tab.id)}
                  className={`${
                    activeTab === tab.id
                      ? "border-blue-500 text-blue-600"
                      : "border-transparent text-gray-500 hover:text-gray-700 hover:border-gray-300"
                  } whitespace-nowrap py-4 px-1 border-b-2 font-medium text-sm flex items-center gap-2`}
                >
                  <Icon className="w-4 h-4" />
                  {tab.label}
                </button>
              );
            })}
          </nav>
        </div>
      </div>

      {/* Active View */}
      <div className="bg-white rounded-lg shadow-sm">
        {renderActiveComponent()}
      </div>
    </div>
  );
};

export default MarketAnalysis;
