import React, { useState, useEffect } from 'react';
import { BarChart, Bar, XAxis, YAxis, CartesianGrid, Tooltip, ResponsiveContainer } from 'recharts';
import { Card, CardContent, CardHeader, CardTitle } from '@/components/ui/card';
import { adminService } from '../../../api/adminService';
import { Loader2 } from 'lucide-react';

export const SystemMetricsChart: React.FC = () => {
    const [data, setData] = useState<any[]>([]);
    const [loading, setLoading] = useState(true);

    useEffect(() => {
        const fetchUsage = async () => {
            try {
                const res = await adminService.apiKeys.monitorUsage();
                // Ensure data is array
                const chartData = Array.isArray(res.data) ? res.data : [];
                setData(chartData);
            } catch (error) {
                console.error("Failed to fetch usage stats:", error);
            } finally {
                setLoading(false);
            }
        };
        fetchUsage();
    }, []);

    if (loading) {
        return <div className="h-[300px] flex items-center justify-center text-gray-400"><Loader2 className="animate-spin mr-2" /> Loading Traffic Data...</div>;
    }

    return (
        <Card className="shadow-sm border-gray-200">
            <CardHeader>
                <CardTitle className="text-sm font-bold text-gray-700">API Traffic Volume (Last 30 Days)</CardTitle>
            </CardHeader>
            <CardContent className="h-[300px]">
                <ResponsiveContainer width="100%" height="100%">
                    <BarChart data={data} margin={{ top: 10, right: 30, left: 0, bottom: 0 }}>
                        <CartesianGrid strokeDasharray="3 3" vertical={false} stroke="#f0f0f0" />
                        <XAxis dataKey="date" fontSize={12} tickLine={false} axisLine={false} />
                        <YAxis fontSize={12} tickLine={false} axisLine={false} />
                        <Tooltip
                            contentStyle={{ borderRadius: '8px', border: 'none', boxShadow: '0 4px 12px rgba(0,0,0,0.1)' }}
                            cursor={{ fill: '#f3f4f6' }}
                        />
                        <Bar dataKey="count" fill="#8b5cf6" radius={[4, 4, 0, 0]} name="Requests" />
                    </BarChart>
                </ResponsiveContainer>
            </CardContent>
        </Card>
    );
};
