import React from "react";
import {
  CheckCircle,
  BarChart3,
  Home,
  MapPin,
  DollarSign,
  Star,
  Building,
  Users,
  Award,
  TrendingUp,
  Target,
  Zap,
} from "lucide-react";

export function BenchmarkReports() {
  return (
    <>
      <div className="bg-gray-50 py-16">
        <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
          <div className="text-center mb-12">
            <h2 className="text-3xl font-bold text-gray-900 mb-4">
              Comprehensive Property Comparison Framework
            </h2>
            <p className="text-lg text-gray-600 max-w-3xl mx-auto">
              Side-by-side analysis of multiple properties using advanced metrics for informed decision making
            </p>
          </div>
          
          <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6">
            <div className="bg-white p-6 rounded-xl shadow-sm border border-gray-200 text-center">
              <BarChart3 className="w-12 h-12 text-[#0056D2] mx-auto mb-4" />
              <h3 className="text-lg font-semibold text-gray-900 mb-2">Price Comparison</h3>
              <p className="text-sm text-gray-600">Cost per sq ft & total investment</p>
            </div>
            
            <div className="bg-white p-6 rounded-xl shadow-sm border border-gray-200 text-center">
              <Star className="w-12 h-12 text-[#0056D2] mx-auto mb-4" />
              <h3 className="text-lg font-semibold text-gray-900 mb-2">Amenity Analysis</h3>
              <p className="text-sm text-gray-600">Quality ratings & unique features</p>
            </div>
            
            <div className="bg-white p-6 rounded-xl shadow-sm border border-gray-200 text-center">
              <MapPin className="w-12 h-12 text-[#0056D2] mx-auto mb-4" />
              <h3 className="text-lg font-semibold text-gray-900 mb-2">Location Score</h3>
              <p className="text-sm text-gray-600">Connectivity & growth potential</p>
            </div>
            
            <div className="bg-white p-6 rounded-xl shadow-sm border border-gray-200 text-center">
              <Target className="w-12 h-12 text-[#0056D2] mx-auto mb-4" />
              <h3 className="text-lg font-semibold text-gray-900 mb-2">Value Index</h3>
              <p className="text-sm text-gray-600">Best value recommendation</p>
            </div>
          </div>
        </div>
      </div>

      <div className="bg-white py-12">
        <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
          <div className="space-y-12">
            
            <div className="grid grid-cols-1 lg:grid-cols-2 gap-12 items-center">
              <div>
                <div className="flex items-center mb-4">
                  <div className="bg-[#0056D2] text-white rounded-full w-8 h-8 flex items-center justify-center text-sm font-bold mr-3">1</div>
                  <h3 className="text-2xl font-bold text-gray-900">Side-by-Side Property Comparison</h3>
                </div>
                <p className="text-gray-600 mb-6">Detailed comparison matrix showing key metrics and specifications across multiple properties.</p>
                <ul className="space-y-3">
                  <li className="flex items-start gap-3">
                    <CheckCircle className="w-5 h-5 text-green-500 mt-0.5 flex-shrink-0" />
                    <span className="text-gray-700">Price per square foot analysis and total cost breakdown</span>
                  </li>
                  <li className="flex items-start gap-3">
                    <CheckCircle className="w-5 h-5 text-green-500 mt-0.5 flex-shrink-0" />
                    <span className="text-gray-700">Configuration comparison (2BHK, 3BHK, 4BHK options)</span>
                  </li>
                  <li className="flex items-start gap-3">
                    <CheckCircle className="w-5 h-5 text-green-500 mt-0.5 flex-shrink-0" />
                    <span className="text-gray-700">Carpet area vs built-up area efficiency ratios</span>
                  </li>
                  <li className="flex items-start gap-3">
                    <CheckCircle className="w-5 h-5 text-green-500 mt-0.5 flex-shrink-0" />
                    <span className="text-gray-700">Additional costs (parking, maintenance, registration)</span>
                  </li>
                  <li className="flex items-start gap-3">
                    <CheckCircle className="w-5 h-5 text-green-500 mt-0.5 flex-shrink-0" />
                    <span className="text-gray-700">Payment plans and financing options comparison</span>
                  </li>
                </ul>
              </div>
              <div className="bg-gradient-to-br from-blue-50 to-indigo-50 p-8 rounded-2xl">
                <img
                  src="https://images.unsplash.com/photo-1460925895917-afdab827c52f?w=500&h=350&fit=crop"
                  alt="Property Comparison Analysis"
                  className="w-full h-64 object-cover rounded-xl shadow-lg"
                />
              </div>
            </div>

            <div className="grid grid-cols-1 lg:grid-cols-2 gap-12 items-center">
              <div className="bg-gradient-to-br from-green-50 to-emerald-50 p-8 rounded-2xl order-2 lg:order-1">
                <img
                  src="https://images.unsplash.com/photo-1545324418-cc1a3fa10c00?w=500&h=350&fit=crop"
                  alt="Amenity Comparison"
                  className="w-full h-64 object-cover rounded-xl shadow-lg"
                />
              </div>
              <div className="order-1 lg:order-2">
                <div className="flex items-center mb-4">
                  <div className="bg-[#0056D2] text-white rounded-full w-8 h-8 flex items-center justify-center text-sm font-bold mr-3">2</div>
                  <h3 className="text-2xl font-bold text-gray-900">Amenity Benchmarking</h3>
                </div>
                <p className="text-gray-600 mb-6">Comprehensive evaluation of amenities quality, availability, and unique features across properties.</p>
                <ul className="space-y-3">
                  <li className="flex items-start gap-3">
                    <Star className="w-5 h-5 text-yellow-500 mt-0.5 flex-shrink-0" />
                    <span className="text-gray-700">Clubhouse facilities and recreational amenities scoring</span>
                  </li>
                  <li className="flex items-start gap-3">
                    <Star className="w-5 h-5 text-yellow-500 mt-0.5 flex-shrink-0" />
                    <span className="text-gray-700">Swimming pool, gym, and sports facilities comparison</span>
                  </li>
                  <li className="flex items-start gap-3">
                    <Star className="w-5 h-5 text-yellow-500 mt-0.5 flex-shrink-0" />
                    <span className="text-gray-700">Security features and safety systems evaluation</span>
                  </li>
                  <li className="flex items-start gap-3">
                    <Star className="w-5 h-5 text-yellow-500 mt-0.5 flex-shrink-0" />
                    <span className="text-gray-700">Parking availability and convenience assessment</span>
                  </li>
                  <li className="flex items-start gap-3">
                    <Star className="w-5 h-5 text-yellow-500 mt-0.5 flex-shrink-0" />
                    <span className="text-gray-700">Unique selling points and premium features analysis</span>
                  </li>
                </ul>
              </div>
            </div>

            <div className="grid grid-cols-1 lg:grid-cols-2 gap-12 items-center">
              <div>
                <div className="flex items-center mb-4">
                  <div className="bg-[#0056D2] text-white rounded-full w-8 h-8 flex items-center justify-center text-sm font-bold mr-3">3</div>
                  <h3 className="text-2xl font-bold text-gray-900">Construction & Age Comparison</h3>
                </div>
                <p className="text-gray-600 mb-6">Analysis of construction quality, building age, and structural integrity across properties.</p>
                <ul className="space-y-3">
                  <li className="flex items-start gap-3">
                    <Building className="w-5 h-5 text-blue-500 mt-0.5 flex-shrink-0" />
                    <span className="text-gray-700">Construction quality and materials used assessment</span>
                  </li>
                  <li className="flex items-start gap-3">
                    <Building className="w-5 h-5 text-blue-500 mt-0.5 flex-shrink-0" />
                    <span className="text-gray-700">Building age and maintenance requirements analysis</span>
                  </li>
                  <li className="flex items-start gap-3">
                    <Building className="w-5 h-5 text-blue-500 mt-0.5 flex-shrink-0" />
                    <span className="text-gray-700">Structural safety and earthquake resistance comparison</span>
                  </li>
                  <li className="flex items-start gap-3">
                    <Building className="w-5 h-5 text-blue-500 mt-0.5 flex-shrink-0" />
                    <span className="text-gray-700">Renovation potential and modernization scope</span>
                  </li>
                  <li className="flex items-start gap-3">
                    <Building className="w-5 h-5 text-blue-500 mt-0.5 flex-shrink-0" />
                    <span className="text-gray-700">Energy efficiency and sustainability features</span>
                  </li>
                </ul>
              </div>
              <div className="bg-gradient-to-br from-purple-50 to-pink-50 p-8 rounded-2xl">
                <img
                  src="https://images.unsplash.com/photo-1503387762-592deb58ef4e?w=500&h=350&fit=crop"
                  alt="Construction Quality Analysis"
                  className="w-full h-64 object-cover rounded-xl shadow-lg"
                />
              </div>
            </div>

            <div className="grid grid-cols-1 lg:grid-cols-2 gap-12 items-center">
              <div className="bg-gradient-to-br from-indigo-50 to-purple-50 p-8 rounded-2xl order-2 lg:order-1">
                <img
                  src="https://images.unsplash.com/photo-1554224155-6726b3ff858f?w=500&h=350&fit=crop"
                  alt="ROI Analysis"
                  className="w-full h-64 object-cover rounded-xl shadow-lg"
                />
              </div>
              <div className="order-1 lg:order-2">
                <div className="flex items-center mb-4">
                  <div className="bg-[#0056D2] text-white rounded-full w-8 h-8 flex items-center justify-center text-sm font-bold mr-3">4</div>
                  <h3 className="text-2xl font-bold text-gray-900">ROI & Rental Yield Benchmark</h3>
                </div>
                <p className="text-gray-600 mb-6">Comprehensive financial comparison including investment returns and rental profitability.</p>
                <ul className="space-y-3">
                  <li className="flex items-start gap-3">
                    <DollarSign className="w-5 h-5 text-green-500 mt-0.5 flex-shrink-0" />
                    <span className="text-gray-700">Expected ROI for 3, 5, and 10-year investment horizons</span>
                  </li>
                  <li className="flex items-start gap-3">
                    <Home className="w-5 h-5 text-green-500 mt-0.5 flex-shrink-0" />
                    <span className="text-gray-700">Rental yield potential and occupancy rate analysis</span>
                  </li>
                  <li className="flex items-start gap-3">
                    <TrendingUp className="w-5 h-5 text-green-500 mt-0.5 flex-shrink-0" />
                    <span className="text-gray-700">Capital appreciation trends and future projections</span>
                  </li>
                  <li className="flex items-start gap-3">
                    <BarChart3 className="w-5 h-5 text-green-500 mt-0.5 flex-shrink-0" />
                    <span className="text-gray-700">Break-even analysis and investment recovery timeline</span>
                  </li>
                  <li className="flex items-start gap-3">
                    <Target className="w-5 h-5 text-green-500 mt-0.5 flex-shrink-0" />
                    <span className="text-gray-700">Risk-adjusted returns and market volatility assessment</span>
                  </li>
                </ul>
              </div>
            </div>

            <div className="bg-[#0056D2] text-white p-12 rounded-2xl text-center">
              <div className="flex items-center justify-center mb-6">
                <div className="bg-white text-[#0056D2] rounded-full w-12 h-12 flex items-center justify-center text-lg font-bold mr-4">★</div>
                <h3 className="text-3xl font-bold">Final Value-for-Money Ranking</h3>
              </div>
              <p className="text-xl text-blue-100 mb-8 max-w-3xl mx-auto">
                Comprehensive scoring system to identify the best value property based on all comparison parameters
              </p>
              <div className="grid grid-cols-2 md:grid-cols-3 lg:grid-cols-6 gap-6">
                <div className="bg-white/10 p-4 rounded-lg">
                  <DollarSign className="w-8 h-8 mx-auto mb-2" />
                  <p className="text-sm font-medium">Price Value</p>
                </div>
                <div className="bg-white/10 p-4 rounded-lg">
                  <Star className="w-8 h-8 mx-auto mb-2" />
                  <p className="text-sm font-medium">Amenity Score</p>
                </div>
                <div className="bg-white/10 p-4 rounded-lg">
                  <MapPin className="w-8 h-8 mx-auto mb-2" />
                  <p className="text-sm font-medium">Location Rating</p>
                </div>
                <div className="bg-white/10 p-4 rounded-lg">
                  <Building className="w-8 h-8 mx-auto mb-2" />
                  <p className="text-sm font-medium">Builder Trust</p>
                </div>
                <div className="bg-white/10 p-4 rounded-lg">
                  <TrendingUp className="w-8 h-8 mx-auto mb-2" />
                  <p className="text-sm font-medium">ROI Potential</p>
                </div>
                <div className="bg-white/10 p-4 rounded-lg">
                  <Target className="w-8 h-8 mx-auto mb-2" />
                  <p className="text-sm font-medium">Overall Value</p>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </>
  );
}