import React from "react";
import {
  CheckCircle,
  Building,
  Award,
  Users,
  Shield,
  Star,
  Calendar,
  FileText,
  AlertTriangle,
  TrendingUp,
  Clock,
  Target,
} from "lucide-react";

export function BuilderReputation() {
  return (
    <>
      {/* Key Features Overview */}
      <div className="bg-gray-50 py-16">
        <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
          <div className="text-center mb-12">
            <h2 className="text-3xl font-bold text-gray-900 mb-4">
              Complete Builder Credibility Assessment
            </h2>
            <p className="text-lg text-gray-600 max-w-3xl mx-auto">
              Comprehensive evaluation of builder reliability, track record, and market reputation using verified data and customer feedback
            </p>
          </div>
          
          <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6">
            <div className="bg-white p-6 rounded-xl shadow-sm border border-gray-200 text-center">
              <Clock className="w-12 h-12 text-[#0056D2] mx-auto mb-4" />
              <h3 className="text-lg font-semibold text-gray-900 mb-2">Delivery Track Record</h3>
              <p className="text-sm text-gray-600">On-time vs delayed project analysis</p>
            </div>
            
            <div className="bg-white p-6 rounded-xl shadow-sm border border-gray-200 text-center">
              <Building className="w-12 h-12 text-[#0056D2] mx-auto mb-4" />
              <h3 className="text-lg font-semibold text-gray-900 mb-2">Quality Assessment</h3>
              <p className="text-sm text-gray-600">Construction materials & durability</p>
            </div>
            
            <div className="bg-white p-6 rounded-xl shadow-sm border border-gray-200 text-center">
              <Users className="w-12 h-12 text-[#0056D2] mx-auto mb-4" />
              <h3 className="text-lg font-semibold text-gray-900 mb-2">Customer Satisfaction</h3>
              <p className="text-sm text-gray-600">Reviews & complaint analysis</p>
            </div>
            
            <div className="bg-white p-6 rounded-xl shadow-sm border border-gray-200 text-center">
              <Shield className="w-12 h-12 text-[#0056D2] mx-auto mb-4" />
              <h3 className="text-lg font-semibold text-gray-900 mb-2">Legal Compliance</h3>
              <p className="text-sm text-gray-600">RERA & regulatory verification</p>
            </div>
          </div>
        </div>
      </div>

      {/* Detailed Analysis Modules */}
      <div className="bg-white py-12">
        <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
          <div className="space-y-12">
            
            {/* 1. Delivery Track Record */}
            <div className="grid grid-cols-1 lg:grid-cols-2 gap-12 items-center">
              <div>
                <div className="flex items-center mb-4">
                  <div className="bg-[#0056D2] text-white rounded-full w-8 h-8 flex items-center justify-center text-sm font-bold mr-3">1</div>
                  <h3 className="text-2xl font-bold text-gray-900">Builder Delivery Track Record</h3>
                </div>
                <p className="text-gray-600 mb-6">Comprehensive analysis of builder's project completion history and timeline adherence.</p>
                <ul className="space-y-3">
                  <li className="flex items-start gap-3">
                    <CheckCircle className="w-5 h-5 text-green-500 mt-0.5 flex-shrink-0" />
                    <span className="text-gray-700">On-time delivery percentage across all projects</span>
                  </li>
                  <li className="flex items-start gap-3">
                    <CheckCircle className="w-5 h-5 text-green-500 mt-0.5 flex-shrink-0" />
                    <span className="text-gray-700">Average delay duration and reasons analysis</span>
                  </li>
                  <li className="flex items-start gap-3">
                    <CheckCircle className="w-5 h-5 text-green-500 mt-0.5 flex-shrink-0" />
                    <span className="text-gray-700">Project completion timeline trends over years</span>
                  </li>
                  <li className="flex items-start gap-3">
                    <CheckCircle className="w-5 h-5 text-green-500 mt-0.5 flex-shrink-0" />
                    <span className="text-gray-700">Comparison with industry standards</span>
                  </li>
                  <li className="flex items-start gap-3">
                    <CheckCircle className="w-5 h-5 text-green-500 mt-0.5 flex-shrink-0" />
                    <span className="text-gray-700">Current project status and delivery forecasts</span>
                  </li>
                </ul>
              </div>
              <div className="bg-gradient-to-br from-blue-50 to-indigo-50 p-8 rounded-2xl">
                <img
                  src="/builder.png"
                  alt="Construction Timeline Analysis"
                  className="w-full h-64 object-cover rounded-xl shadow-lg"
                />
              </div>
            </div>

            {/* 2. Construction Quality Score */}
            <div className="grid grid-cols-1 lg:grid-cols-2 gap-12 items-center">
              <div className="bg-gradient-to-br from-green-50 to-emerald-50 p-8 rounded-2xl order-2 lg:order-1">
                <img
                  src="https://images.unsplash.com/photo-1503387762-592deb58ef4e?w=500&h=350&fit=crop"
                  alt="Construction Quality Assessment"
                  className="w-full h-64 object-cover rounded-xl shadow-lg"
                />
              </div>
              <div className="order-1 lg:order-2">
                <div className="flex items-center mb-4">
                  <div className="bg-[#0056D2] text-white rounded-full w-8 h-8 flex items-center justify-center text-sm font-bold mr-3">2</div>
                  <h3 className="text-2xl font-bold text-gray-900">Construction Quality Score</h3>
                </div>
                <p className="text-gray-600 mb-6">Detailed evaluation of construction materials, techniques, and long-term durability.</p>
                <ul className="space-y-3">
                  <li className="flex items-start gap-3">
                    <CheckCircle className="w-5 h-5 text-green-500 mt-0.5 flex-shrink-0" />
                    <span className="text-gray-700">Materials quality audit and brand verification</span>
                  </li>
                  <li className="flex items-start gap-3">
                    <CheckCircle className="w-5 h-5 text-green-500 mt-0.5 flex-shrink-0" />
                    <span className="text-gray-700">Construction methodology and safety standards</span>
                  </li>
                  <li className="flex items-start gap-3">
                    <CheckCircle className="w-5 h-5 text-green-500 mt-0.5 flex-shrink-0" />
                    <span className="text-gray-700">Structural integrity and earthquake resistance</span>
                  </li>
                  <li className="flex items-start gap-3">
                    <CheckCircle className="w-5 h-5 text-green-500 mt-0.5 flex-shrink-0" />
                    <span className="text-gray-700">Finishing quality and attention to detail</span>
                  </li>
                  <li className="flex items-start gap-3">
                    <CheckCircle className="w-5 h-5 text-green-500 mt-0.5 flex-shrink-0" />
                    <span className="text-gray-700">Long-term maintenance and durability assessment</span>
                  </li>
                </ul>
              </div>
            </div>

            {/* 3. Customer Satisfaction Analytics */}
            <div className="grid grid-cols-1 lg:grid-cols-2 gap-12 items-center">
              <div>
                <div className="flex items-center mb-4">
                  <div className="bg-[#0056D2] text-white rounded-full w-8 h-8 flex items-center justify-center text-sm font-bold mr-3">3</div>
                  <h3 className="text-2xl font-bold text-gray-900">Customer Satisfaction & Review Analytics</h3>
                </div>
                <p className="text-gray-600 mb-6">Comprehensive analysis of customer feedback, ratings, and complaint resolution patterns.</p>
                <ul className="space-y-3">
                  <li className="flex items-start gap-3">
                    <Star className="w-5 h-5 text-yellow-500 mt-0.5 flex-shrink-0" />
                    <span className="text-gray-700">Aggregated customer ratings across platforms</span>
                  </li>
                  <li className="flex items-start gap-3">
                    <Star className="w-5 h-5 text-yellow-500 mt-0.5 flex-shrink-0" />
                    <span className="text-gray-700">Complaint categories and resolution timeframes</span>
                  </li>
                  <li className="flex items-start gap-3">
                    <Star className="w-5 h-5 text-yellow-500 mt-0.5 flex-shrink-0" />
                    <span className="text-gray-700">Customer service responsiveness analysis</span>
                  </li>
                  <li className="flex items-start gap-3">
                    <Star className="w-5 h-5 text-yellow-500 mt-0.5 flex-shrink-0" />
                    <span className="text-gray-700">Post-handover support and maintenance quality</span>
                  </li>
                  <li className="flex items-start gap-3">
                    <Star className="w-5 h-5 text-yellow-500 mt-0.5 flex-shrink-0" />
                    <span className="text-gray-700">Referral rates and repeat customer percentage</span>
                  </li>
                </ul>
              </div>
              <div className="bg-gradient-to-br from-purple-50 to-pink-50 p-8 rounded-2xl">
                <img
                  src="https://images.unsplash.com/photo-1556761175-b413da4baf72?w=500&h=350&fit=crop"
                  alt="Customer Satisfaction Analysis"
                  className="w-full h-64 object-cover rounded-xl shadow-lg"
                />
              </div>
            </div>

            {/* 4. RERA Compliance & Legal Status */}
            <div className="grid grid-cols-1 lg:grid-cols-2 gap-12 items-center">
              <div className="bg-gradient-to-br from-orange-50 to-red-50 p-8 rounded-2xl order-2 lg:order-1">
                <img
                  src="https://images.unsplash.com/photo-1589829545856-d10d557cf95f?w=500&h=350&fit=crop"
                  alt="Legal Compliance Check"
                  className="w-full h-64 object-cover rounded-xl shadow-lg"
                />
              </div>
              <div className="order-1 lg:order-2">
                <div className="flex items-center mb-4">
                  <div className="bg-[#0056D2] text-white rounded-full w-8 h-8 flex items-center justify-center text-sm font-bold mr-3">4</div>
                  <h3 className="text-2xl font-bold text-gray-900">RERA Compliance & Litigations</h3>
                </div>
                <p className="text-gray-600 mb-6">Complete legal compliance verification and litigation history analysis.</p>
                <ul className="space-y-3">
                  <li className="flex items-start gap-3">
                    <Shield className="w-5 h-5 text-blue-500 mt-0.5 flex-shrink-0" />
                    <span className="text-gray-700">RERA registration status and compliance score</span>
                  </li>
                  <li className="flex items-start gap-3">
                    <AlertTriangle className="w-5 h-5 text-orange-500 mt-0.5 flex-shrink-0" />
                    <span className="text-gray-700">Ongoing and past litigation cases analysis</span>
                  </li>
                  <li className="flex items-start gap-3">
                    <FileText className="w-5 h-5 text-green-500 mt-0.5 flex-shrink-0" />
                    <span className="text-gray-700">Regulatory penalties and violation history</span>
                  </li>
                  <li className="flex items-start gap-3">
                    <Shield className="w-5 h-5 text-blue-500 mt-0.5 flex-shrink-0" />
                    <span className="text-gray-700">Environmental and safety clearances</span>
                  </li>
                  <li className="flex items-start gap-3">
                    <CheckCircle className="w-5 h-5 text-green-500 mt-0.5 flex-shrink-0" />
                    <span className="text-gray-700">Financial transparency and audit reports</span>
                  </li>
                </ul>
              </div>
            </div>

            {/* 5. Financial Stability Check */}
            <div className="grid grid-cols-1 lg:grid-cols-2 gap-12 items-center">
              <div>
                <div className="flex items-center mb-4">
                  <div className="bg-[#0056D2] text-white rounded-full w-8 h-8 flex items-center justify-center text-sm font-bold mr-3">5</div>
                  <h3 className="text-2xl font-bold text-gray-900">Financial Stability Check</h3>
                </div>
                <p className="text-gray-600 mb-6">Assessment of builder's financial health and market stability for project completion assurance.</p>
                <ul className="space-y-3">
                  <li className="flex items-start gap-3">
                    <TrendingUp className="w-5 h-5 text-green-500 mt-0.5 flex-shrink-0" />
                    <span className="text-gray-700">Revenue growth and profitability trends</span>
                  </li>
                  <li className="flex items-start gap-3">
                    <Building className="w-5 h-5 text-blue-500 mt-0.5 flex-shrink-0" />
                    <span className="text-gray-700">Market presence and years of operation</span>
                  </li>
                  <li className="flex items-start gap-3">
                    <Shield className="w-5 h-5 text-purple-500 mt-0.5 flex-shrink-0" />
                    <span className="text-gray-700">Credit rating and loan repayment history</span>
                  </li>
                  <li className="flex items-start gap-3">
                    <Target className="w-5 h-5 text-orange-500 mt-0.5 flex-shrink-0" />
                    <span className="text-gray-700">Project funding sources and cash flow</span>
                  </li>
                  <li className="flex items-start gap-3">
                    <Award className="w-5 h-5 text-yellow-500 mt-0.5 flex-shrink-0" />
                    <span className="text-gray-700">Industry awards and recognition history</span>
                  </li>
                </ul>
              </div>
              <div className="bg-gradient-to-br from-teal-50 to-cyan-50 p-8 rounded-2xl">
                <img
                  src="https://images.unsplash.com/photo-1554224155-8d04cb21cd6c?w=500&h=350&fit=crop"
                  alt="Financial Stability Analysis"
                  className="w-full h-64 object-cover rounded-xl shadow-lg"
                />
              </div>
            </div>

            {/* 6. Brand Value & Market Standing */}
            <div className="grid grid-cols-1 lg:grid-cols-2 gap-12 items-center">
              <div className="bg-gradient-to-br from-indigo-50 to-purple-50 p-8 rounded-2xl order-2 lg:order-1">
                <img
                  src="https://images.unsplash.com/photo-1560472354-b33ff0c44a43?w=500&h=350&fit=crop"
                  alt="Brand Value Assessment"
                  className="w-full h-64 object-cover rounded-xl shadow-lg"
                />
              </div>
              <div className="order-1 lg:order-2">
                <div className="flex items-center mb-4">
                  <div className="bg-[#0056D2] text-white rounded-full w-8 h-8 flex items-center justify-center text-sm font-bold mr-3">6</div>
                  <h3 className="text-2xl font-bold text-gray-900">Brand Value & Market Standing</h3>
                </div>
                <p className="text-gray-600 mb-6">Evaluation of builder's market reputation, brand strength, and industry positioning.</p>
                <ul className="space-y-3">
                  <li className="flex items-start gap-3">
                    <Award className="w-5 h-5 text-yellow-500 mt-0.5 flex-shrink-0" />
                    <span className="text-gray-700">Industry awards and certifications received</span>
                  </li>
                  <li className="flex items-start gap-3">
                    <Star className="w-5 h-5 text-blue-500 mt-0.5 flex-shrink-0" />
                    <span className="text-gray-700">Market ranking among peer builders</span>
                  </li>
                  <li className="flex items-start gap-3">
                    <Users className="w-5 h-5 text-green-500 mt-0.5 flex-shrink-0" />
                    <span className="text-gray-700">Media coverage and public perception analysis</span>
                  </li>
                  <li className="flex items-start gap-3">
                    <Building className="w-5 h-5 text-purple-500 mt-0.5 flex-shrink-0" />
                    <span className="text-gray-700">Portfolio diversity and project scale</span>
                  </li>
                  <li className="flex items-start gap-3">
                    <TrendingUp className="w-5 h-5 text-orange-500 mt-0.5 flex-shrink-0" />
                    <span className="text-gray-700">Innovation and sustainability initiatives</span>
                  </li>
                </ul>
              </div>
            </div>

            {/* Final Builder Scorecard */}
            <div className="bg-[#0056D2] text-white p-12 rounded-2xl text-center">
              <div className="flex items-center justify-center mb-6">
                <div className="bg-white text-[#0056D2] rounded-full w-12 h-12 flex items-center justify-center text-lg font-bold mr-4">✓</div>
                <h3 className="text-3xl font-bold">Final Builder Credibility Score</h3>
              </div>
              <p className="text-xl text-blue-100 mb-8 max-w-3xl mx-auto">
                Comprehensive rating combining all assessment parameters for informed decision making
              </p>
              <div className="grid grid-cols-2 md:grid-cols-3 lg:grid-cols-6 gap-6">
                <div className="bg-white/10 p-4 rounded-lg">
                  <Clock className="w-8 h-8 mx-auto mb-2" />
                  <p className="text-sm font-medium">Delivery Record</p>
                </div>
                <div className="bg-white/10 p-4 rounded-lg">
                  <Building className="w-8 h-8 mx-auto mb-2" />
                  <p className="text-sm font-medium">Quality Score</p>
                </div>
                <div className="bg-white/10 p-4 rounded-lg">
                  <Users className="w-8 h-8 mx-auto mb-2" />
                  <p className="text-sm font-medium">Customer Rating</p>
                </div>
                <div className="bg-white/10 p-4 rounded-lg">
                  <Shield className="w-8 h-8 mx-auto mb-2" />
                  <p className="text-sm font-medium">Legal Compliance</p>
                </div>
                <div className="bg-white/10 p-4 rounded-lg">
                  <TrendingUp className="w-8 h-8 mx-auto mb-2" />
                  <p className="text-sm font-medium">Financial Health</p>
                </div>
                <div className="bg-white/10 p-4 rounded-lg">
                  <Award className="w-8 h-8 mx-auto mb-2" />
                  <p className="text-sm font-medium">Brand Value</p>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </>
  );
}