import React from "react";
import {
  CheckCircle,
  FileText,
  Target,
  DollarSign,
  Users,
  Calendar,
  BarChart3,
  Shield,
  TrendingUp,
  Award,
  Zap,
  Star,
} from "lucide-react";

export function CustomReport() {
  return (
    <>
      {/* Key Features Overview */}
      <div className="bg-gray-50 py-16">
        <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
          <div className="text-center mb-12">
            <h2 className="text-3xl font-bold text-gray-900 mb-4">
              Personalized Property Advisory Framework
            </h2>
            <p className="text-lg text-gray-600 max-w-3xl mx-auto">
              Custom insights tailored to your specific requirements, budget, goals, and risk preferences
            </p>
          </div>
          
          <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6">
            <div className="bg-white p-6 rounded-xl shadow-sm border border-gray-200 text-center">
              <Target className="w-12 h-12 text-[#0056D2] mx-auto mb-4" />
              <h3 className="text-lg font-semibold text-gray-900 mb-2">Personalized Matching</h3>
              <p className="text-sm text-gray-600">Budget & preference based recommendations</p>
            </div>
            
            <div className="bg-white p-6 rounded-xl shadow-sm border border-gray-200 text-center">
              <Shield className="w-12 h-12 text-[#0056D2] mx-auto mb-4" />
              <h3 className="text-lg font-semibold text-gray-900 mb-2">Risk Assessment</h3>
              <p className="text-sm text-gray-600">Comprehensive risk evaluation</p>
            </div>
            
            <div className="bg-white p-6 rounded-xl shadow-sm border border-gray-200 text-center">
              <Calendar className="w-12 h-12 text-[#0056D2] mx-auto mb-4" />
              <h3 className="text-lg font-semibold text-gray-900 mb-2">Timing Analysis</h3>
              <p className="text-sm text-gray-600">Best time to buy guidance</p>
            </div>
            
            <div className="bg-white p-6 rounded-xl shadow-sm border border-gray-200 text-center">
              <DollarSign className="w-12 h-12 text-[#0056D2] mx-auto mb-4" />
              <h3 className="text-lg font-semibold text-gray-900 mb-2">Financial Planning</h3>
              <p className="text-sm text-gray-600">EMI & investment optimization</p>
            </div>
          </div>
        </div>
      </div>

      {/* Detailed Analysis Modules */}
      <div className="bg-white py-12">
        <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
          <div className="space-y-12">
            
            {/* 1. Personalized Property Recommendations */}
            <div className="grid grid-cols-1 lg:grid-cols-2 gap-12 items-center">
              <div>
                <div className="flex items-center mb-4">
                  <div className="bg-[#0056D2] text-white rounded-full w-8 h-8 flex items-center justify-center text-sm font-bold mr-3">1</div>
                  <h3 className="text-2xl font-bold text-gray-900">Personalized Property Recommendations</h3>
                </div>
                <p className="text-gray-600 mb-6">Curated property suggestions based on your specific budget, purpose, and lifestyle preferences.</p>
                <ul className="space-y-3">
                  <li className="flex items-start gap-3">
                    <CheckCircle className="w-5 h-5 text-green-500 mt-0.5 flex-shrink-0" />
                    <span className="text-gray-700">Budget-aligned property filtering and matching</span>
                  </li>
                  <li className="flex items-start gap-3">
                    <CheckCircle className="w-5 h-5 text-green-500 mt-0.5 flex-shrink-0" />
                    <span className="text-gray-700">Purpose-based recommendations (investment vs self-use)</span>
                  </li>
                  <li className="flex items-start gap-3">
                    <CheckCircle className="w-5 h-5 text-green-500 mt-0.5 flex-shrink-0" />
                    <span className="text-gray-700">Lifestyle preference matching (amenities, location)</span>
                  </li>
                  <li className="flex items-start gap-3">
                    <CheckCircle className="w-5 h-5 text-green-500 mt-0.5 flex-shrink-0" />
                    <span className="text-gray-700">Family size and configuration suitability</span>
                  </li>
                  <li className="flex items-start gap-3">
                    <CheckCircle className="w-5 h-5 text-green-500 mt-0.5 flex-shrink-0" />
                    <span className="text-gray-700">Commute and connectivity preference optimization</span>
                  </li>
                </ul>
              </div>
              <div className="bg-gradient-to-br from-blue-50 to-indigo-50 p-8 rounded-2xl">
                <img
                  src="https://images.unsplash.com/photo-1560472354-b33ff0c44a43?w=500&h=350&fit=crop"
                  alt="Personalized Recommendations"
                  className="w-full h-64 object-cover rounded-xl shadow-lg"
                />
              </div>
            </div>

            {/* 2. Buyer's Risk Score Evaluation */}
            <div className="grid grid-cols-1 lg:grid-cols-2 gap-12 items-center">
              <div className="bg-gradient-to-br from-green-50 to-emerald-50 p-8 rounded-2xl order-2 lg:order-1">
                <img
                  src="https://images.unsplash.com/photo-1551288049-bebda4e38f71?w=500&h=350&fit=crop"
                  alt="Risk Assessment"
                  className="w-full h-64 object-cover rounded-xl shadow-lg"
                />
              </div>
              <div className="order-1 lg:order-2">
                <div className="flex items-center mb-4">
                  <div className="bg-[#0056D2] text-white rounded-full w-8 h-8 flex items-center justify-center text-sm font-bold mr-3">2</div>
                  <h3 className="text-2xl font-bold text-gray-900">Buyer's Risk Score Evaluation</h3>
                </div>
                <p className="text-gray-600 mb-6">Comprehensive risk assessment across financial, legal, builder, and market dimensions.</p>
                <ul className="space-y-3">
                  <li className="flex items-start gap-3">
                    <Shield className="w-5 h-5 text-red-500 mt-0.5 flex-shrink-0" />
                    <span className="text-gray-700">Financial risk assessment and affordability analysis</span>
                  </li>
                  <li className="flex items-start gap-3">
                    <FileText className="w-5 h-5 text-orange-500 mt-0.5 flex-shrink-0" />
                    <span className="text-gray-700">Legal and documentation risk evaluation</span>
                  </li>
                  <li className="flex items-start gap-3">
                    <Users className="w-5 h-5 text-purple-500 mt-0.5 flex-shrink-0" />
                    <span className="text-gray-700">Builder credibility and delivery risk analysis</span>
                  </li>
                  <li className="flex items-start gap-3">
                    <BarChart3 className="w-5 h-5 text-blue-500 mt-0.5 flex-shrink-0" />
                    <span className="text-gray-700">Market volatility and investment risk scoring</span>
                  </li>
                  <li className="flex items-start gap-3">
                    <Target className="w-5 h-5 text-green-500 mt-0.5 flex-shrink-0" />
                    <span className="text-gray-700">Overall risk score with mitigation strategies</span>
                  </li>
                </ul>
              </div>
            </div>

            {/* 3. Best Time to Buy Analysis */}
            <div className="grid grid-cols-1 lg:grid-cols-2 gap-12 items-center">
              <div>
                <div className="flex items-center mb-4">
                  <div className="bg-[#0056D2] text-white rounded-full w-8 h-8 flex items-center justify-center text-sm font-bold mr-3">3</div>
                  <h3 className="text-2xl font-bold text-gray-900">Best Time to Buy Analysis</h3>
                </div>
                <p className="text-gray-600 mb-6">Market timing analysis with seasonal trends and price forecasts for optimal purchase decisions.</p>
                <ul className="space-y-3">
                  <li className="flex items-start gap-3">
                    <Calendar className="w-5 h-5 text-green-500 mt-0.5 flex-shrink-0" />
                    <span className="text-gray-700">Seasonal market trends and price cycle analysis</span>
                  </li>
                  <li className="flex items-start gap-3">
                    <TrendingUp className="w-5 h-5 text-blue-500 mt-0.5 flex-shrink-0" />
                    <span className="text-gray-700">Price forecast and market momentum indicators</span>
                  </li>
                  <li className="flex items-start gap-3">
                    <DollarSign className="w-5 h-5 text-purple-500 mt-0.5 flex-shrink-0" />
                    <span className="text-gray-700">Interest rate trends and financing cost analysis</span>
                  </li>
                  <li className="flex items-start gap-3">
                    <BarChart3 className="w-5 h-5 text-orange-500 mt-0.5 flex-shrink-0" />
                    <span className="text-gray-700">Supply pipeline and inventory level assessment</span>
                  </li>
                  <li className="flex items-start gap-3">
                    <Zap className="w-5 h-5 text-red-500 mt-0.5 flex-shrink-0" />
                    <span className="text-gray-700">Optimal purchase window and urgency indicators</span>
                  </li>
                </ul>
              </div>
              <div className="bg-gradient-to-br from-purple-50 to-pink-50 p-8 rounded-2xl">
                <img
                  src="https://images.unsplash.com/photo-1460925895917-afdab827c52f?w=500&h=350&fit=crop"
                  alt="Market Timing Analysis"
                  className="w-full h-64 object-cover rounded-xl shadow-lg"
                />
              </div>
            </div>

            {/* 4. Negotiation Guidance */}
            <div className="grid grid-cols-1 lg:grid-cols-2 gap-12 items-center">
              <div className="bg-gradient-to-br from-orange-50 to-red-50 p-8 rounded-2xl order-2 lg:order-1">
                <img
                  src="https://images.unsplash.com/photo-1556761175-b413da4baf72?w=500&h=350&fit=crop"
                  alt="Negotiation Strategy"
                  className="w-full h-64 object-cover rounded-xl shadow-lg"
                />
              </div>
              <div className="order-1 lg:order-2">
                <div className="flex items-center mb-4">
                  <div className="bg-[#0056D2] text-white rounded-full w-8 h-8 flex items-center justify-center text-sm font-bold mr-3">4</div>
                  <h3 className="text-2xl font-bold text-gray-900">Negotiation Guidance</h3>
                </div>
                <p className="text-gray-600 mb-6">Strategic negotiation advice with market comparisons and optimal pricing recommendations.</p>
                <ul className="space-y-3">
                  <li className="flex items-start gap-3">
                    <Target className="w-5 h-5 text-green-500 mt-0.5 flex-shrink-0" />
                    <span className="text-gray-700">Ideal negotiation margins and price benchmarks</span>
                  </li>
                  <li className="flex items-start gap-3">
                    <BarChart3 className="w-5 h-5 text-blue-500 mt-0.5 flex-shrink-0" />
                    <span className="text-gray-700">Market comparison and competitive pricing analysis</span>
                  </li>
                  <li className="flex items-start gap-3">
                    <Award className="w-5 h-5 text-purple-500 mt-0.5 flex-shrink-0" />
                    <span className="text-gray-700">Builder offers, discounts, and incentive evaluation</span>
                  </li>
                  <li className="flex items-start gap-3">
                    <Calendar className="w-5 h-5 text-orange-500 mt-0.5 flex-shrink-0" />
                    <span className="text-gray-700">Payment plan optimization and financing terms</span>
                  </li>
                  <li className="flex items-start gap-3">
                    <Star className="w-5 h-5 text-yellow-500 mt-0.5 flex-shrink-0" />
                    <span className="text-gray-700">Negotiation tactics and closing strategies</span>
                  </li>
                </ul>
              </div>
            </div>

            {/* 5. Financial Planning */}
            <div className="grid grid-cols-1 lg:grid-cols-2 gap-12 items-center">
              <div>
                <div className="flex items-center mb-4">
                  <div className="bg-[#0056D2] text-white rounded-full w-8 h-8 flex items-center justify-center text-sm font-bold mr-3">5</div>
                  <h3 className="text-2xl font-bold text-gray-900">Financial Planning</h3>
                </div>
                <p className="text-gray-600 mb-6">Comprehensive financial planning with EMI calculations, tax benefits, and investment optimization.</p>
                <ul className="space-y-3">
                  <li className="flex items-start gap-3">
                    <DollarSign className="w-5 h-5 text-green-500 mt-0.5 flex-shrink-0" />
                    <span className="text-gray-700">EMI calculators and affordability assessment</span>
                  </li>
                  <li className="flex items-start gap-3">
                    <BarChart3 className="w-5 h-5 text-blue-500 mt-0.5 flex-shrink-0" />
                    <span className="text-gray-700">Loan comparison and interest rate optimization</span>
                  </li>
                  <li className="flex items-start gap-3">
                    <FileText className="w-5 h-5 text-purple-500 mt-0.5 flex-shrink-0" />
                    <span className="text-gray-700">Tax benefits analysis and deduction maximization</span>
                  </li>
                  <li className="flex items-start gap-3">
                    <TrendingUp className="w-5 h-5 text-orange-500 mt-0.5 flex-shrink-0" />
                    <span className="text-gray-700">Investment vs self-use financial comparison</span>
                  </li>
                  <li className="flex items-start gap-3">
                    <Target className="w-5 h-5 text-red-500 mt-0.5 flex-shrink-0" />
                    <span className="text-gray-700">Cash flow planning and budget optimization</span>
                  </li>
                </ul>
              </div>
              <div className="bg-gradient-to-br from-teal-50 to-cyan-50 p-8 rounded-2xl">
                <img
                  src="https://images.unsplash.com/photo-1554224155-8d04cb21cd6c?w=500&h=350&fit=crop"
                  alt="Financial Planning"
                  className="w-full h-64 object-cover rounded-xl shadow-lg"
                />
              </div>
            </div>

            {/* 6. Custom Property Comparisons */}
            <div className="grid grid-cols-1 lg:grid-cols-2 gap-12 items-center">
              <div className="bg-gradient-to-br from-indigo-50 to-purple-50 p-8 rounded-2xl order-2 lg:order-1">
                <img
                  src="https://images.unsplash.com/photo-1590283603385-17ffb3a7f29f?w=500&h=350&fit=crop"
                  alt="Property Comparison"
                  className="w-full h-64 object-cover rounded-xl shadow-lg"
                />
              </div>
              <div className="order-1 lg:order-2">
                <div className="flex items-center mb-4">
                  <div className="bg-[#0056D2] text-white rounded-full w-8 h-8 flex items-center justify-center text-sm font-bold mr-3">6</div>
                  <h3 className="text-2xl font-bold text-gray-900">Custom Property Comparisons</h3>
                </div>
                <p className="text-gray-600 mb-6">Detailed side-by-side comparison of shortlisted properties with pros & cons analysis.</p>
                <ul className="space-y-3">
                  <li className="flex items-start gap-3">
                    <BarChart3 className="w-5 h-5 text-green-500 mt-0.5 flex-shrink-0" />
                    <span className="text-gray-700">Side-by-side feature and specification comparison</span>
                  </li>
                  <li className="flex items-start gap-3">
                    <DollarSign className="w-5 h-5 text-blue-500 mt-0.5 flex-shrink-0" />
                    <span className="text-gray-700">Value-for-money analysis and cost-benefit ratio</span>
                  </li>
                  <li className="flex items-start gap-3">
                    <Star className="w-5 h-5 text-purple-500 mt-0.5 flex-shrink-0" />
                    <span className="text-gray-700">Pros and cons matrix for each property</span>
                  </li>
                  <li className="flex items-start gap-3">
                    <Target className="w-5 h-5 text-orange-500 mt-0.5 flex-shrink-0" />
                    <span className="text-gray-700">Suitability scoring based on your preferences</span>
                  </li>
                  <li className="flex items-start gap-3">
                    <Award className="w-5 h-5 text-yellow-500 mt-0.5 flex-shrink-0" />
                    <span className="text-gray-700">Final ranking and recommendation priority</span>
                  </li>
                </ul>
              </div>
            </div>

            {/* Custom Advisory Dashboard */}
            <div className="bg-[#0056D2] text-white p-12 rounded-2xl text-center">
              <div className="flex items-center justify-center mb-6">
                <div className="bg-white text-[#0056D2] rounded-full w-12 h-12 flex items-center justify-center text-lg font-bold mr-4">🎯</div>
                <h3 className="text-3xl font-bold">Personalized Investment Decision Support</h3>
              </div>
              <p className="text-xl text-blue-100 mb-8 max-w-3xl mx-auto">
                Complete decision framework tailored to your unique requirements and investment goals
              </p>
              <div className="grid grid-cols-2 md:grid-cols-3 lg:grid-cols-6 gap-6">
                <div className="bg-white/10 p-4 rounded-lg">
                  <Target className="w-8 h-8 mx-auto mb-2" />
                  <p className="text-sm font-medium">Personal Match</p>
                </div>
                <div className="bg-white/10 p-4 rounded-lg">
                  <Shield className="w-8 h-8 mx-auto mb-2" />
                  <p className="text-sm font-medium">Risk Score</p>
                </div>
                <div className="bg-white/10 p-4 rounded-lg">
                  <Calendar className="w-8 h-8 mx-auto mb-2" />
                  <p className="text-sm font-medium">Timing Guide</p>
                </div>
                <div className="bg-white/10 p-4 rounded-lg">
                  <DollarSign className="w-8 h-8 mx-auto mb-2" />
                  <p className="text-sm font-medium">Price Strategy</p>
                </div>
                <div className="bg-white/10 p-4 rounded-lg">
                  <BarChart3 className="w-8 h-8 mx-auto mb-2" />
                  <p className="text-sm font-medium">Financial Plan</p>
                </div>
                <div className="bg-white/10 p-4 rounded-lg">
                  <Award className="w-8 h-8 mx-auto mb-2" />
                  <p className="text-sm font-medium">Final Choice</p>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </>
  );
}