import React from "react";
import {
  Users,
  MapPin,
  Shield,
  Activity,
  Calendar,
  FileText,
  DollarSign,
  CheckCircle,
  Target,
  Star,
  Building,
  Phone,
  Mail,
  Globe,
} from "lucide-react";

export function NriAssistance() {
  return (
    <>
      {/* Key Features Overview */}
      <div className="bg-gray-50 py-16">
        <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
          <div className="text-center mb-12">
            <h2 className="text-3xl font-bold text-gray-900 mb-4">
              Complete NRI Assistance Framework
            </h2>
            <p className="text-lg text-gray-600 max-w-3xl mx-auto">
              Our comprehensive support combines 7 key modules to provide seamless property investment assistance for NRIs worldwide
            </p>
          </div>
          
          <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6">
            <div className="bg-white p-6 rounded-xl shadow-sm border border-gray-200 text-center">
              <Shield className="w-12 h-12 text-[#0056D2] mx-auto mb-4" />
              <h3 className="text-lg font-semibold text-gray-900 mb-2">Legal Compliance</h3>
              <p className="text-sm text-gray-600">RBI & FEMA guidelines</p>
            </div>
            
            <div className="bg-white p-6 rounded-xl shadow-sm border border-gray-200 text-center">
              <FileText className="w-12 h-12 text-[#0056D2] mx-auto mb-4" />
              <h3 className="text-lg font-semibold text-gray-900 mb-2">POA Support</h3>
              <p className="text-sm text-gray-600">Documentation assistance</p>
            </div>
            
            <div className="bg-white p-6 rounded-xl shadow-sm border border-gray-200 text-center">
              <Activity className="w-12 h-12 text-[#0056D2] mx-auto mb-4" />
              <h3 className="text-lg font-semibold text-gray-900 mb-2">Virtual Tours</h3>
              <p className="text-sm text-gray-600">Remote property viewing</p>
            </div>
            
            <div className="bg-white p-6 rounded-xl shadow-sm border border-gray-200 text-center">
              <Globe className="w-12 h-12 text-[#0056D2] mx-auto mb-4" />
              <h3 className="text-lg font-semibold text-gray-900 mb-2">24x7 Support</h3>
              <p className="text-sm text-gray-600">Global accessibility</p>
            </div>
          </div>
        </div>
      </div>

      {/* Detailed Analysis Modules */}
      <div className="bg-white py-12">
        <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
          <div className="space-y-12">
            
            {/* 1. Regulatory & Compliance Guidance */}
            <div className="grid grid-cols-1 lg:grid-cols-2 gap-12 items-center">
              <div>
                <div className="flex items-center mb-4">
                  <div className="bg-[#0056D2] text-white rounded-full w-8 h-8 flex items-center justify-center text-sm font-bold mr-3">1</div>
                  <h3 className="text-2xl font-bold text-gray-900">Regulatory & Compliance Guidance</h3>
                </div>
                <p className="text-gray-600 mb-6">Complete guidance on RBI, FEMA, and Income Tax regulations for seamless NRI property investments with legal compliance.</p>
                <ul className="space-y-3">
                  <li className="flex items-start gap-3">
                    <CheckCircle className="w-5 h-5 text-green-500 mt-0.5 flex-shrink-0" />
                    <span className="text-gray-700">RBI guidelines and investment limit explanations</span>
                  </li>
                  <li className="flex items-start gap-3">
                    <CheckCircle className="w-5 h-5 text-green-500 mt-0.5 flex-shrink-0" />
                    <span className="text-gray-700">FEMA rules and fund repatriation guidance</span>
                  </li>
                  <li className="flex items-start gap-3">
                    <CheckCircle className="w-5 h-5 text-green-500 mt-0.5 flex-shrink-0" />
                    <span className="text-gray-700">Tax compliance and optimization strategies</span>
                  </li>
                  <li className="flex items-start gap-3">
                    <CheckCircle className="w-5 h-5 text-green-500 mt-0.5 flex-shrink-0" />
                    <span className="text-gray-700">Real-time regulatory updates and alerts</span>
                  </li>
                </ul>
              </div>
              <div className="bg-gradient-to-br from-blue-50 to-indigo-50 p-8 rounded-2xl">
                <img
                  src="/regulatory & Compliance.png"
                  alt="Legal Compliance and Regulations"
                  className="w-full h-80 object-cover rounded-xl shadow-lg"
                />
              </div>
            </div>

            {/* 2. POA (Power of Attorney) Support */}
            <div className="grid grid-cols-1 lg:grid-cols-2 gap-12 items-center">
              <div className="bg-gradient-to-br from-green-50 to-emerald-50 p-8 rounded-2xl order-2 lg:order-1">
                <img
                  src="/POA.png"
                  alt="Power of Attorney Documentation"
                  className="w-full h-80 object-cover rounded-xl shadow-lg"
                />
              </div>
              <div className="order-1 lg:order-2">
                <div className="flex items-center mb-4">
                  <div className="bg-[#0056D2] text-white rounded-full w-8 h-8 flex items-center justify-center text-sm font-bold mr-3">2</div>
                  <h3 className="text-2xl font-bold text-gray-900">POA (Power of Attorney) Support</h3>
                </div>
                <p className="text-gray-600 mb-6">Complete documentation and verification assistance with templates and end-to-end POA management services.</p>
                <ul className="space-y-3">
                  <li className="flex items-start gap-3">
                    <CheckCircle className="w-5 h-5 text-green-500 mt-0.5 flex-shrink-0" />
                    <span className="text-gray-700">Special/General POA templates and guidance</span>
                  </li>
                  <li className="flex items-start gap-3">
                    <CheckCircle className="w-5 h-5 text-green-500 mt-0.5 flex-shrink-0" />
                    <span className="text-gray-700">Notarization and attestation procedures</span>
                  </li>
                  <li className="flex items-start gap-3">
                    <CheckCircle className="w-5 h-5 text-green-500 mt-0.5 flex-shrink-0" />
                    <span className="text-gray-700">Indian Embassy coordination and support</span>
                  </li>
                  <li className="flex items-start gap-3">
                    <CheckCircle className="w-5 h-5 text-green-500 mt-0.5 flex-shrink-0" />
                    <span className="text-gray-700">POA verification status tracking system</span>
                  </li>
                </ul>
              </div>
            </div>

            {/* 3. Virtual Assistance & Remote Evaluation */}
            <div className="grid grid-cols-1 lg:grid-cols-2 gap-12 items-center">
              <div>
                <div className="flex items-center mb-4">
                  <div className="bg-[#0056D2] text-white rounded-full w-8 h-8 flex items-center justify-center text-sm font-bold mr-3">3</div>
                  <h3 className="text-2xl font-bold text-gray-900">Virtual Assistance & Remote Evaluation</h3>
                </div>
                <p className="text-gray-600 mb-6">High-quality virtual tours and remote property assessment with live walkthroughs and drone footage.</p>
                <ul className="space-y-3">
                  <li className="flex items-start gap-3">
                    <Activity className="w-5 h-5 text-purple-500 mt-0.5 flex-shrink-0" />
                    <span className="text-gray-700">Live virtual property tours and walkthroughs</span>
                  </li>
                  <li className="flex items-start gap-3">
                    <Activity className="w-5 h-5 text-purple-500 mt-0.5 flex-shrink-0" />
                    <span className="text-gray-700">Drone footage and aerial property views</span>
                  </li>
                  <li className="flex items-start gap-3">
                    <Activity className="w-5 h-5 text-purple-500 mt-0.5 flex-shrink-0" />
                    <span className="text-gray-700">360-degree property visualization</span>
                  </li>
                  <li className="flex items-start gap-3">
                    <Activity className="w-5 h-5 text-purple-500 mt-0.5 flex-shrink-0" />
                    <span className="text-gray-700">Remote property condition assessment</span>
                  </li>
                </ul>
              </div>
              <div className="bg-gradient-to-br from-purple-50 to-pink-50 p-8 rounded-2xl">
                <img
                  src="/virtual assistance.png"
                  alt="Virtual Property Tours and Remote Viewing"
                  className="w-full h-80 object-cover rounded-xl shadow-lg"
                />
              </div>
            </div>

            {/* 4. End-to-End Documentation & Transaction Support */}
            <div className="grid grid-cols-1 lg:grid-cols-2 gap-12 items-center">
              <div className="bg-gradient-to-br from-orange-50 to-red-50 p-8 rounded-2xl order-2 lg:order-1">
                <img
                  src="/end to end doc.png"
                  alt="Documentation and Transaction Support"
                  className="w-full h-80 object-cover rounded-xl shadow-lg"
                />
              </div>
              <div className="order-1 lg:order-2">
                <div className="flex items-center mb-4">
                  <div className="bg-[#0056D2] text-white rounded-full w-8 h-8 flex items-center justify-center text-sm font-bold mr-3">4</div>
                  <h3 className="text-2xl font-bold text-gray-900">End-to-End Documentation & Transaction Support</h3>
                </div>
                <p className="text-gray-600 mb-6">Complete digital assistance for seamless property transactions with expert coordination and real-time tracking.</p>
                <ul className="space-y-3">
                  <li className="flex items-start gap-3">
                    <FileText className="w-5 h-5 text-orange-500 mt-0.5 flex-shrink-0" />
                    <span className="text-gray-700">Digital documentation and agreement processing</span>
                  </li>
                  <li className="flex items-start gap-3">
                    <DollarSign className="w-5 h-5 text-orange-500 mt-0.5 flex-shrink-0" />
                    <span className="text-gray-700">NRI-friendly home loan assistance</span>
                  </li>
                  <li className="flex items-start gap-3">
                    <Target className="w-5 h-5 text-orange-500 mt-0.5 flex-shrink-0" />
                    <span className="text-gray-700">Real-time transaction tracking and updates</span>
                  </li>
                  <li className="flex items-start gap-3">
                    <Users className="w-5 h-5 text-orange-500 mt-0.5 flex-shrink-0" />
                    <span className="text-gray-700">Expert coordination with all stakeholders</span>
                  </li>
                </ul>
              </div>
            </div>

            {/* 5. Negotiation & Deal Handling */}
            <div className="grid grid-cols-1 lg:grid-cols-2 gap-12 items-center">
              <div>
                <div className="flex items-center mb-4">
                  <div className="bg-[#0056D2] text-white rounded-full w-8 h-8 flex items-center justify-center text-sm font-bold mr-3">5</div>
                  <h3 className="text-2xl font-bold text-gray-900">Negotiation & Deal Handling</h3>
                </div>
                <p className="text-gray-600 mb-6">Expert-led support for optimal pricing with market intelligence and comprehensive risk assessment.</p>
                <ul className="space-y-3">
                  <li className="flex items-start gap-3">
                    <Target className="w-5 h-5 text-teal-500 mt-0.5 flex-shrink-0" />
                    <span className="text-gray-700">Best pricing strategies and negotiation support</span>
                  </li>
                  <li className="flex items-start gap-3">
                    <Target className="w-5 h-5 text-teal-500 mt-0.5 flex-shrink-0" />
                    <span className="text-gray-700">Investment risk assessment and guidance</span>
                  </li>
                  <li className="flex items-start gap-3">
                    <Target className="w-5 h-5 text-teal-500 mt-0.5 flex-shrink-0" />
                    <span className="text-gray-700">Builder credibility verification</span>
                  </li>
                  <li className="flex items-start gap-3">
                    <Target className="w-5 h-5 text-teal-500 mt-0.5 flex-shrink-0" />
                    <span className="text-gray-700">Market intelligence and price comparison</span>
                  </li>
                </ul>
              </div>
              <div className="bg-gradient-to-br from-teal-50 to-cyan-50 p-8 rounded-2xl">
                <img
                  src="/negotiation.png"
                  alt="Negotiation and Deal Management"
                  className="w-full h-80 object-cover rounded-xl shadow-lg"
                />
              </div>
            </div>

            {/* 6. Post-Purchase Support */}
            <div className="grid grid-cols-1 lg:grid-cols-2 gap-12 items-center">
              <div className="bg-gradient-to-br from-indigo-50 to-purple-50 p-8 rounded-2xl order-2 lg:order-1">
                <img
                  src="/post purchase.png"
                  alt="Property Management and Support"
                  className="w-full h-80 object-cover rounded-xl shadow-lg"
                />
              </div>
              <div className="order-1 lg:order-2">
                <div className="flex items-center mb-4">
                  <div className="bg-[#0056D2] text-white rounded-full w-8 h-8 flex items-center justify-center text-sm font-bold mr-3">6</div>
                  <h3 className="text-2xl font-bold text-gray-900">Post-Purchase Support</h3>
                </div>
                <p className="text-gray-600 mb-6">Comprehensive property management for absentee owners with rental management and maintenance services.</p>
                <ul className="space-y-3">
                  <li className="flex items-start gap-3">
                    <Star className="w-5 h-5 text-indigo-500 mt-0.5 flex-shrink-0" />
                    <span className="text-gray-700">Tenant finding and rental management</span>
                  </li>
                  <li className="flex items-start gap-3">
                    <Star className="w-5 h-5 text-indigo-500 mt-0.5 flex-shrink-0" />
                    <span className="text-gray-700">Property maintenance and upkeep services</span>
                  </li>
                  <li className="flex items-start gap-3">
                    <Star className="w-5 h-5 text-indigo-500 mt-0.5 flex-shrink-0" />
                    <span className="text-gray-700">Monthly property status reports</span>
                  </li>
                  <li className="flex items-start gap-3">
                    <Star className="w-5 h-5 text-indigo-500 mt-0.5 flex-shrink-0" />
                    <span className="text-gray-700">Regular inspection visits and updates</span>
                  </li>
                </ul>
              </div>
            </div>

            {/* 7. Secure Communication Hub */}
            <div className="bg-[#0056D2] text-white p-12 rounded-2xl text-center">
              <div className="flex items-center justify-center mb-6">
                <div className="bg-white text-[#0056D2] rounded-full w-12 h-12 flex items-center justify-center text-lg font-bold mr-4">7</div>
                <h3 className="text-3xl font-bold">Secure Communication Hub</h3>
              </div>
              <p className="text-xl text-blue-100 mb-8 max-w-3xl mx-auto">
                NRI-exclusive support channel with global accessibility and 24x7 availability across all time zones
              </p>
              <div className="grid grid-cols-2 md:grid-cols-3 lg:grid-cols-6 gap-6">
                <div className="bg-white/10 p-4 rounded-lg">
                  <Mail className="w-8 h-8 mx-auto mb-2" />
                  <p className="text-sm font-medium">Multi-Channel Support</p>
                </div>
                <div className="bg-white/10 p-4 rounded-lg">
                  <Shield className="w-8 h-8 mx-auto mb-2" />
                  <p className="text-sm font-medium">Secure Storage</p>
                </div>
                <div className="bg-white/10 p-4 rounded-lg">
                  <Calendar className="w-8 h-8 mx-auto mb-2" />
                  <p className="text-sm font-medium">24x7 Availability</p>
                </div>
                <div className="bg-white/10 p-4 rounded-lg">
                  <Globe className="w-8 h-8 mx-auto mb-2" />
                  <p className="text-sm font-medium">Global Access</p>
                </div>
                <div className="bg-white/10 p-4 rounded-lg">
                  <Phone className="w-8 h-8 mx-auto mb-2" />
                  <p className="text-sm font-medium">Video Calls</p>
                </div>
                <div className="bg-white/10 p-4 rounded-lg">
                  <Users className="w-8 h-8 mx-auto mb-2" />
                  <p className="text-sm font-medium">NRI Specialists</p>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </>
  );
}