import React from "react";
import {
  FileText,
  Building,
  Activity,
  DollarSign,
  Shield,
  Award,
  CheckCircle,
  Star,
  MapPin,
  Camera,
  Users,
} from "lucide-react";

export function PropertyDossier() {
  return (
    <>
      {/* Key Features Overview */}
      <div className="bg-gray-50 py-16">
        <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
          <div className="text-center mb-12">
            <h2 className="text-3xl font-bold text-gray-900 mb-4">
              Complete Property Intelligence Framework
            </h2>
            <p className="text-lg text-gray-600 max-w-3xl mx-auto">
              Our comprehensive analysis combines 9 key modules to create your personalized property dossier
            </p>
          </div>
          
          <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6">
            <div className="bg-white p-6 rounded-xl shadow-sm border border-gray-200 text-center">
              <Building className="w-12 h-12 text-[#0056D2] mx-auto mb-4" />
              <h3 className="text-lg font-semibold text-gray-900 mb-2">Property Overview</h3>
              <p className="text-sm text-gray-600">Complete property snapshot</p>
            </div>
            
            <div className="bg-white p-6 rounded-xl shadow-sm border border-gray-200 text-center">
              <Activity className="w-12 h-12 text-[#0056D2] mx-auto mb-4" />
              <h3 className="text-lg font-semibold text-gray-900 mb-2">Technical Analysis</h3>
              <p className="text-sm text-gray-600">Construction & quality</p>
            </div>
            
            <div className="bg-white p-6 rounded-xl shadow-sm border border-gray-200 text-center">
              <DollarSign className="w-12 h-12 text-[#0056D2] mx-auto mb-4" />
              <h3 className="text-lg font-semibold text-gray-900 mb-2">Financial Breakdown</h3>
              <p className="text-sm text-gray-600">Price & EMI analysis</p>
            </div>
            
            <div className="bg-white p-6 rounded-xl shadow-sm border border-gray-200 text-center">
              <Shield className="w-12 h-12 text-[#0056D2] mx-auto mb-4" />
              <h3 className="text-lg font-semibold text-gray-900 mb-2">Legal Documentation</h3>
              <p className="text-sm text-gray-600">Compliance verification</p>
            </div>
          </div>
        </div>
      </div>

      {/* Detailed Analysis Modules */}
      <div className="bg-white py-12">
        <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
          <div className="space-y-12">
            
            {/* 1. Property Overview & Snapshot */}
            <div className="grid grid-cols-1 lg:grid-cols-2 gap-12 items-center">
              <div>
                <div className="flex items-center mb-4">
                  <div className="bg-[#0056D2] text-white rounded-full w-8 h-8 flex items-center justify-center text-sm font-bold mr-3">1</div>
                  <h3 className="text-2xl font-bold text-gray-900">Property Overview & Snapshot</h3>
                </div>
                <p className="text-gray-600 mb-6">High-level summary with property intelligence and comprehensive scoring across all key parameters.</p>
                <ul className="space-y-3">
                  <li className="flex items-start gap-3">
                    <CheckCircle className="w-5 h-5 text-green-500 mt-0.5 flex-shrink-0" />
                    <span className="text-gray-700">Property type, location, and configuration details</span>
                  </li>
                  <li className="flex items-start gap-3">
                    <CheckCircle className="w-5 h-5 text-green-500 mt-0.5 flex-shrink-0" />
                    <span className="text-gray-700">Builder reputation and project status analysis</span>
                  </li>
                  <li className="flex items-start gap-3">
                    <CheckCircle className="w-5 h-5 text-green-500 mt-0.5 flex-shrink-0" />
                    <span className="text-gray-700">Quick property score dashboard with ratings</span>
                  </li>
                  <li className="flex items-start gap-3">
                    <CheckCircle className="w-5 h-5 text-green-500 mt-0.5 flex-shrink-0" />
                    <span className="text-gray-700">Visual property summary with key highlights</span>
                  </li>
                </ul>
              </div>
              <div className="bg-gradient-to-br from-blue-50 to-indigo-50 p-8 rounded-2xl">
                <img
                  src="https://images.unsplash.com/photo-1560518883-ce09059eeffa?w=500&h=350&fit=crop"
                  alt="Property Overview and Analysis"
                  className="w-full h-80 object-cover rounded-xl shadow-lg"
                />
              </div>
            </div>

            {/* 2. Technical & Structural Information */}
            <div className="grid grid-cols-1 lg:grid-cols-2 gap-12 items-center">
              <div className="bg-gradient-to-br from-green-50 to-emerald-50 p-8 rounded-2xl order-2 lg:order-1">
                <img
                  src="https://images.unsplash.com/photo-1486406146926-c627a92ad1ab?w=500&h=350&fit=crop"
                  alt="Technical Construction Analysis"
                  className="w-full h-80 object-cover rounded-xl shadow-lg"
                />
              </div>
              <div className="order-1 lg:order-2">
                <div className="flex items-center mb-4">
                  <div className="bg-[#0056D2] text-white rounded-full w-8 h-8 flex items-center justify-center text-sm font-bold mr-3">2</div>
                  <h3 className="text-2xl font-bold text-gray-900">Technical & Structural Information</h3>
                </div>
                <p className="text-gray-600 mb-6">Construction quality insights and material specifications with detailed structural analysis and safety compliance.</p>
                <ul className="space-y-3">
                  <li className="flex items-start gap-3">
                    <CheckCircle className="w-5 h-5 text-green-500 mt-0.5 flex-shrink-0" />
                    <span className="text-gray-700">Detailed floor plan and space utilization analysis</span>
                  </li>
                  <li className="flex items-start gap-3">
                    <CheckCircle className="w-5 h-5 text-green-500 mt-0.5 flex-shrink-0" />
                    <span className="text-gray-700">Material specifications and construction quality</span>
                  </li>
                  <li className="flex items-start gap-3">
                    <CheckCircle className="w-5 h-5 text-green-500 mt-0.5 flex-shrink-0" />
                    <span className="text-gray-700">Safety compliance and earthquake resistance</span>
                  </li>
                  <li className="flex items-start gap-3">
                    <CheckCircle className="w-5 h-5 text-green-500 mt-0.5 flex-shrink-0" />
                    <span className="text-gray-700">Fire safety and amenities standards verification</span>
                  </li>
                </ul>
              </div>
            </div>

            {/* 3. Financial Breakdown & Analysis */}
            <div className="grid grid-cols-1 lg:grid-cols-2 gap-12 items-center">
              <div>
                <div className="flex items-center mb-4">
                  <div className="bg-[#0056D2] text-white rounded-full w-8 h-8 flex items-center justify-center text-sm font-bold mr-3">3</div>
                  <h3 className="text-2xl font-bold text-gray-900">Financial Breakdown & Analysis</h3>
                </div>
                <p className="text-gray-600 mb-6">Comprehensive price structure with EMI guidance, market comparisons, and detailed investment analysis.</p>
                <ul className="space-y-3">
                  <li className="flex items-start gap-3">
                    <CheckCircle className="w-5 h-5 text-green-500 mt-0.5 flex-shrink-0" />
                    <span className="text-gray-700">Complete price breakdown with taxes and charges</span>
                  </li>
                  <li className="flex items-start gap-3">
                    <CheckCircle className="w-5 h-5 text-green-500 mt-0.5 flex-shrink-0" />
                    <span className="text-gray-700">EMI calculations and loan eligibility analysis</span>
                  </li>
                  <li className="flex items-start gap-3">
                    <CheckCircle className="w-5 h-5 text-green-500 mt-0.5 flex-shrink-0" />
                    <span className="text-gray-700">Market price comparison and value assessment</span>
                  </li>
                  <li className="flex items-start gap-3">
                    <CheckCircle className="w-5 h-5 text-green-500 mt-0.5 flex-shrink-0" />
                    <span className="text-gray-700">Investment analysis with ROI projections</span>
                  </li>
                </ul>
              </div>
              <div className="bg-gradient-to-br from-amber-50 to-orange-50 p-8 rounded-2xl">
                <img
                  src="https://images.unsplash.com/photo-1460925895917-afdab827c52f?w=500&h=350&fit=crop"
                  alt="Financial Analysis and Investment"
                  className="w-full h-80 object-cover rounded-xl shadow-lg"
                />
              </div>
            </div>

            {/* 4. Legal & Documentation Checklist */}
            <div className="grid grid-cols-1 lg:grid-cols-2 gap-12 items-center">
              <div className="bg-gradient-to-br from-red-50 to-pink-50 p-8 rounded-2xl order-2 lg:order-1">
                <img
                  src="https://images.unsplash.com/photo-1589829545856-d10d557cf95f?w=500&h=350&fit=crop"
                  alt="Legal Documentation and Compliance"
                  className="w-full h-80 object-cover rounded-xl shadow-lg"
                />
              </div>
              <div className="order-1 lg:order-2">
                <div className="flex items-center mb-4">
                  <div className="bg-[#0056D2] text-white rounded-full w-8 h-8 flex items-center justify-center text-sm font-bold mr-3">4</div>
                  <h3 className="text-2xl font-bold text-gray-900">Legal & Documentation Checklist</h3>
                </div>
                <p className="text-gray-600 mb-6">Complete documentation verification with status indicators and legal compliance assessment.</p>
                <ul className="space-y-3">
                  <li className="flex items-start gap-3">
                    <Shield className="w-5 h-5 text-red-500 mt-0.5 flex-shrink-0" />
                    <span className="text-gray-700">Sale deed and ownership document verification</span>
                  </li>
                  <li className="flex items-start gap-3">
                    <Shield className="w-5 h-5 text-red-500 mt-0.5 flex-shrink-0" />
                    <span className="text-gray-700">RERA registration and compliance status</span>
                  </li>
                  <li className="flex items-start gap-3">
                    <Shield className="w-5 h-5 text-red-500 mt-0.5 flex-shrink-0" />
                    <span className="text-gray-700">Property tax receipts and revenue records</span>
                  </li>
                  <li className="flex items-start gap-3">
                    <Shield className="w-5 h-5 text-red-500 mt-0.5 flex-shrink-0" />
                    <span className="text-gray-700">Building approvals and NOC verification</span>
                  </li>
                </ul>
              </div>
            </div>

            {/* 5. Connectivity & Locality Insights */}
            <div className="grid grid-cols-1 lg:grid-cols-2 gap-12 items-center">
              <div>
                <div className="flex items-center mb-4">
                  <div className="bg-[#0056D2] text-white rounded-full w-8 h-8 flex items-center justify-center text-sm font-bold mr-3">5</div>
                  <h3 className="text-2xl font-bold text-gray-900">Connectivity & Locality Insights</h3>
                </div>
                <p className="text-gray-600 mb-6">Comprehensive locality analysis with commute times, safety assessment, and neighborhood evaluation.</p>
                <ul className="space-y-3">
                  <li className="flex items-start gap-3">
                    <MapPin className="w-5 h-5 text-blue-500 mt-0.5 flex-shrink-0" />
                    <span className="text-gray-700">Transport connectivity and commute analysis</span>
                  </li>
                  <li className="flex items-start gap-3">
                    <MapPin className="w-5 h-5 text-blue-500 mt-0.5 flex-shrink-0" />
                    <span className="text-gray-700">Safety scores and crime index assessment</span>
                  </li>
                  <li className="flex items-start gap-3">
                    <MapPin className="w-5 h-5 text-blue-500 mt-0.5 flex-shrink-0" />
                    <span className="text-gray-700">Nearby amenities and lifestyle facilities</span>
                  </li>
                  <li className="flex items-start gap-3">
                    <MapPin className="w-5 h-5 text-blue-500 mt-0.5 flex-shrink-0" />
                    <span className="text-gray-700">Future development and growth potential</span>
                  </li>
                </ul>
              </div>
              <div className="bg-gradient-to-br from-purple-50 to-indigo-50 p-8 rounded-2xl">
                <img
                  src="https://images.unsplash.com/photo-1449824913935-59a10b8d2000?w=500&h=350&fit=crop"
                  alt="Connectivity and Location Analysis"
                  className="w-full h-80 object-cover rounded-xl shadow-lg"
                />
              </div>
            </div>

            {/* 6. Amenities & Lifestyle Score */}
            <div className="grid grid-cols-1 lg:grid-cols-2 gap-12 items-center">
              <div className="bg-gradient-to-br from-teal-50 to-cyan-50 p-8 rounded-2xl order-2 lg:order-1">
                <img
                  src="https://images.unsplash.com/photo-1571019613454-1cb2f99b2d8b?w=500&h=350&fit=crop"
                  alt="Amenities and Lifestyle Facilities"
                  className="w-full h-80 object-cover rounded-xl shadow-lg"
                />
              </div>
              <div className="order-1 lg:order-2">
                <div className="flex items-center mb-4">
                  <div className="bg-[#0056D2] text-white rounded-full w-8 h-8 flex items-center justify-center text-sm font-bold mr-3">6</div>
                  <h3 className="text-2xl font-bold text-gray-900">Amenities & Lifestyle Score</h3>
                </div>
                <p className="text-gray-600 mb-6">Usage-based ratings of amenities and lifestyle facilities with quality assessment and project comparisons.</p>
                <ul className="space-y-3">
                  <li className="flex items-start gap-3">
                    <Star className="w-5 h-5 text-yellow-500 mt-0.5 flex-shrink-0" />
                    <span className="text-gray-700">Amenity quality ratings and usage analysis</span>
                  </li>
                  <li className="flex items-start gap-3">
                    <Star className="w-5 h-5 text-yellow-500 mt-0.5 flex-shrink-0" />
                    <span className="text-gray-700">Lifestyle facilities and recreational options</span>
                  </li>
                  <li className="flex items-start gap-3">
                    <Star className="w-5 h-5 text-yellow-500 mt-0.5 flex-shrink-0" />
                    <span className="text-gray-700">Project comparison with similar developments</span>
                  </li>
                  <li className="flex items-start gap-3">
                    <Star className="w-5 h-5 text-yellow-500 mt-0.5 flex-shrink-0" />
                    <span className="text-gray-700">Maintenance quality and service standards</span>
                  </li>
                </ul>
              </div>
            </div>

            {/* 7. Property Media File */}
            <div className="grid grid-cols-1 lg:grid-cols-2 gap-12 items-center">
              <div>
                <div className="flex items-center mb-4">
                  <div className="bg-[#0056D2] text-white rounded-full w-8 h-8 flex items-center justify-center text-sm font-bold mr-3">7</div>
                  <h3 className="text-2xl font-bold text-gray-900">Property Media File</h3>
                </div>
                <p className="text-gray-600 mb-6">Curated media collection with photos, 3D layouts, drone views, and virtual tour capabilities.</p>
                <ul className="space-y-3">
                  <li className="flex items-start gap-3">
                    <Camera className="w-5 h-5 text-purple-500 mt-0.5 flex-shrink-0" />
                    <span className="text-gray-700">High-resolution property photographs</span>
                  </li>
                  <li className="flex items-start gap-3">
                    <Camera className="w-5 h-5 text-purple-500 mt-0.5 flex-shrink-0" />
                    <span className="text-gray-700">3D floor plans and layout visualizations</span>
                  </li>
                  <li className="flex items-start gap-3">
                    <Camera className="w-5 h-5 text-purple-500 mt-0.5 flex-shrink-0" />
                    <span className="text-gray-700">Drone footage and aerial property views</span>
                  </li>
                  <li className="flex items-start gap-3">
                    <Camera className="w-5 h-5 text-purple-500 mt-0.5 flex-shrink-0" />
                    <span className="text-gray-700">Virtual tour and 360-degree walkthroughs</span>
                  </li>
                </ul>
              </div>
              <div className="bg-gradient-to-br from-pink-50 to-rose-50 p-8 rounded-2xl">
                <img
                  src="https://images.unsplash.com/photo-1560472354-b33ff0c44a43?w=500&h=350&fit=crop"
                  alt="Property Media and Virtual Tours"
                  className="w-full h-80 object-cover rounded-xl shadow-lg"
                />
              </div>
            </div>

            {/* 8. Personalized Notes & Preferences */}
            <div className="grid grid-cols-1 lg:grid-cols-2 gap-12 items-center">
              <div className="bg-gradient-to-br from-indigo-50 to-purple-50 p-8 rounded-2xl order-2 lg:order-1">
                <img
                  src="/Personalized.png"
                  alt="Personalized Analysis and Preferences"
                  className="w-full h-80 object-cover rounded-xl shadow-lg"
                />
              </div>
              <div className="order-1 lg:order-2">
                <div className="flex items-center mb-4">
                  <div className="bg-[#0056D2] text-white rounded-full w-8 h-8 flex items-center justify-center text-sm font-bold mr-3">8</div>
                  <h3 className="text-2xl font-bold text-gray-900">Personalized Notes & Preferences</h3>
                </div>
                <p className="text-gray-600 mb-6">Dynamic updates and personalized insights based on your specific requirements and investment goals.</p>
                <ul className="space-y-3">
                  <li className="flex items-start gap-3">
                    <Users className="w-5 h-5 text-indigo-500 mt-0.5 flex-shrink-0" />
                    <span className="text-gray-700">Customized analysis based on your preferences</span>
                  </li>
                  <li className="flex items-start gap-3">
                    <Users className="w-5 h-5 text-indigo-500 mt-0.5 flex-shrink-0" />
                    <span className="text-gray-700">Investment goal alignment assessment</span>
                  </li>
                  <li className="flex items-start gap-3">
                    <Users className="w-5 h-5 text-indigo-500 mt-0.5 flex-shrink-0" />
                    <span className="text-gray-700">Dynamic updates and market changes</span>
                  </li>
                  <li className="flex items-start gap-3">
                    <Users className="w-5 h-5 text-indigo-500 mt-0.5 flex-shrink-0" />
                    <span className="text-gray-700">Personalized recommendations and insights</span>
                  </li>
                </ul>
              </div>
            </div>

            {/* 9. Final Expert Recommendation */}
            <div className="bg-[#0056D2] text-white p-12 rounded-2xl text-center">
              <div className="flex items-center justify-center mb-6">
                <div className="bg-white text-[#0056D2] rounded-full w-12 h-12 flex items-center justify-center text-lg font-bold mr-4">9</div>
                <h3 className="text-3xl font-bold">Final Expert Recommendation</h3>
              </div>
              <p className="text-xl text-blue-100 mb-8 max-w-3xl mx-auto">
                Investment suitability assessment combining all analysis modules to provide you with clear, actionable guidance
              </p>
              <div className="grid grid-cols-2 md:grid-cols-3 lg:grid-cols-6 gap-6">
                <div className="bg-white/10 p-4 rounded-lg">
                  <Building className="w-8 h-8 mx-auto mb-2" />
                  <p className="text-sm font-medium">Property Overview</p>
                </div>
                <div className="bg-white/10 p-4 rounded-lg">
                  <Activity className="w-8 h-8 mx-auto mb-2" />
                  <p className="text-sm font-medium">Technical Analysis</p>
                </div>
                <div className="bg-white/10 p-4 rounded-lg">
                  <DollarSign className="w-8 h-8 mx-auto mb-2" />
                  <p className="text-sm font-medium">Financial Breakdown</p>
                </div>
                <div className="bg-white/10 p-4 rounded-lg">
                  <Shield className="w-8 h-8 mx-auto mb-2" />
                  <p className="text-sm font-medium">Legal Documentation</p>
                </div>
                <div className="bg-white/10 p-4 rounded-lg">
                  <MapPin className="w-8 h-8 mx-auto mb-2" />
                  <p className="text-sm font-medium">Location Analysis</p>
                </div>
                <div className="bg-white/10 p-4 rounded-lg">
                  <Award className="w-8 h-8 mx-auto mb-2" />
                  <p className="text-sm font-medium">Final Rating</p>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </>
  );
}