import React from "react";
import {
  CheckCircle,
  DollarSign,
  Home,
  TrendingUp,
  Users,
  Calendar,
  BarChart3,
  MapPin,
  Target,
  Clock,
  Star,
  Zap,
} from "lucide-react";

export function RentalYield() {
  return (
    <>
      {/* Key Features Overview */}
      <div className="bg-gray-50 py-16">
        <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
          <div className="text-center mb-12">
            <h2 className="text-3xl font-bold text-gray-900 mb-4">
              Rental Yield Calculator
            </h2>
            <p className="text-lg text-gray-600 max-w-3xl mx-auto">
              Calculate expected rental income and investment returns based on real market data from your locality
            </p>
          </div>
          
          <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6">
            <div className="bg-white p-6 rounded-xl shadow-sm border border-gray-200 text-center">
              <DollarSign className="w-12 h-12 text-[#0056D2] mx-auto mb-4" />
              <h3 className="text-lg font-semibold text-gray-900 mb-2">Monthly Rent Estimate</h3>
              <p className="text-sm text-gray-600">Based on real market rates</p>
            </div>
            
            <div className="bg-white p-6 rounded-xl shadow-sm border border-gray-200 text-center">
              <BarChart3 className="w-12 h-12 text-[#0056D2] mx-auto mb-4" />
              <h3 className="text-lg font-semibold text-gray-900 mb-2">Rental Yield %</h3>
              <p className="text-sm text-gray-600">Annual return on investment</p>
            </div>
            
            <div className="bg-white p-6 rounded-xl shadow-sm border border-gray-200 text-center">
              <TrendingUp className="w-12 h-12 text-[#0056D2] mx-auto mb-4" />
              <h3 className="text-lg font-semibold text-gray-900 mb-2">Market Comparison</h3>
              <p className="text-sm text-gray-600">vs locality average yield</p>
            </div>
            
            <div className="bg-white p-6 rounded-xl shadow-sm border border-gray-200 text-center">
              <Target className="w-12 h-12 text-[#0056D2] mx-auto mb-4" />
              <h3 className="text-lg font-semibold text-gray-900 mb-2">5-Year Projections</h3>
              <p className="text-sm text-gray-600">Future yield forecasts</p>
            </div>
          </div>
        </div>
      </div>

      {/* Detailed Analysis Modules */}
      <div className="bg-white py-12">
        <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
          <div className="space-y-12">
            
            {/* 1. Expected Monthly Rent Analysis */}
            <div className="grid grid-cols-1 lg:grid-cols-2 gap-12 items-center">
              <div>
                <div className="flex items-center mb-4">
                  <div className="bg-[#0056D2] text-white rounded-full w-8 h-8 flex items-center justify-center text-sm font-bold mr-3">1</div>
                  <h3 className="text-2xl font-bold text-gray-900">Monthly Rent Calculation</h3>
                </div>
                <p className="text-gray-600 mb-6">Calculate expected monthly rent based on real market data from your locality and property specifications.</p>
                <ul className="space-y-3">
                  <li className="flex items-start gap-3">
                    <CheckCircle className="w-5 h-5 text-green-500 mt-0.5 flex-shrink-0" />
                    <span className="text-gray-700">Real market rental rates from similar properties in your locality</span>
                  </li>
                  <li className="flex items-start gap-3">
                    <CheckCircle className="w-5 h-5 text-green-500 mt-0.5 flex-shrink-0" />
                    <span className="text-gray-700">Furnishing status adjustment (unfurnished, semi, fully furnished)</span>
                  </li>
                  <li className="flex items-start gap-3">
                    <CheckCircle className="w-5 h-5 text-green-500 mt-0.5 flex-shrink-0" />
                    <span className="text-gray-700">Property age depreciation factor (0-2 years to 16+ years)</span>
                  </li>
                  <li className="flex items-start gap-3">
                    <CheckCircle className="w-5 h-5 text-green-500 mt-0.5 flex-shrink-0" />
                    <span className="text-gray-700">BHK configuration and built-up area considerations</span>
                  </li>
                  <li className="flex items-start gap-3">
                    <CheckCircle className="w-5 h-5 text-green-500 mt-0.5 flex-shrink-0" />
                    <span className="text-gray-700">Annual rental income projection (Monthly Rent × 12)</span>
                  </li>
                </ul>
              </div>
              <div className="bg-gradient-to-br from-blue-50 to-indigo-50 p-8 rounded-2xl">
                <img
                  src="https://images.unsplash.com/photo-1554224155-6726b3ff858f?w=500&h=350&fit=crop"
                  alt="Rental Rate Analysis"
                  className="w-full h-64 object-cover rounded-xl shadow-lg"
                />
              </div>
            </div>

            {/* 2. Rental Demand Score */}
            <div className="grid grid-cols-1 lg:grid-cols-2 gap-12 items-center">
              <div className="bg-gradient-to-br from-green-50 to-emerald-50 p-8 rounded-2xl order-2 lg:order-1">
                <img
                  src="https://images.unsplash.com/photo-1560472354-b33ff0c44a43?w=500&h=350&fit=crop"
                  alt="Rental Demand Analysis"
                  className="w-full h-64 object-cover rounded-xl shadow-lg"
                />
              </div>
              <div className="order-1 lg:order-2">
                <div className="flex items-center mb-4">
                  <div className="bg-[#0056D2] text-white rounded-full w-8 h-8 flex items-center justify-center text-sm font-bold mr-3">2</div>
                  <h3 className="text-2xl font-bold text-gray-900">Rental Yield Percentage</h3>
                </div>
                <p className="text-gray-600 mb-6">Calculate your annual return on investment as a percentage of property purchase price.</p>
                <ul className="space-y-3">
                  <li className="flex items-start gap-3">
                    <DollarSign className="w-5 h-5 text-blue-500 mt-0.5 flex-shrink-0" />
                    <span className="text-gray-700">Formula: (Annual Rent ÷ Purchase Price) × 100</span>
                  </li>
                  <li className="flex items-start gap-3">
                    <BarChart3 className="w-5 h-5 text-green-500 mt-0.5 flex-shrink-0" />
                    <span className="text-gray-700">Shows percentage return from rental income alone</span>
                  </li>
                  <li className="flex items-start gap-3">
                    <TrendingUp className="w-5 h-5 text-purple-500 mt-0.5 flex-shrink-0" />
                    <span className="text-gray-700">Higher yield means better rental income returns</span>
                  </li>
                  <li className="flex items-start gap-3">
                    <Target className="w-5 h-5 text-yellow-500 mt-0.5 flex-shrink-0" />
                    <span className="text-gray-700">Typical yields in India range from 2-6%</span>
                  </li>
                  <li className="flex items-start gap-3">
                    <CheckCircle className="w-5 h-5 text-orange-500 mt-0.5 flex-shrink-0" />
                    <span className="text-gray-700">ROI metric for comparing investment opportunities</span>
                  </li>
                </ul>
              </div>
            </div>

            {/* 3. Occupancy Trends */}
            <div className="grid grid-cols-1 lg:grid-cols-2 gap-12 items-center">
              <div>
                <div className="flex items-center mb-4">
                  <div className="bg-[#0056D2] text-white rounded-full w-8 h-8 flex items-center justify-center text-sm font-bold mr-3">3</div>
                  <h3 className="text-2xl font-bold text-gray-900">Market Comparison</h3>
                </div>
                <p className="text-gray-600 mb-6">Compare your property's rental yield against the locality average to assess performance.</p>
                <ul className="space-y-3">
                  <li className="flex items-start gap-3">
                    <MapPin className="w-5 h-5 text-green-500 mt-0.5 flex-shrink-0" />
                    <span className="text-gray-700">Locality average yield from real property database</span>
                  </li>
                  <li className="flex items-start gap-3">
                    <BarChart3 className="w-5 h-5 text-blue-500 mt-0.5 flex-shrink-0" />
                    <span className="text-gray-700">Performance rating: Above Average, Average, or Below Average</span>
                  </li>
                  <li className="flex items-start gap-3">
                    <TrendingUp className="w-5 h-5 text-purple-500 mt-0.5 flex-shrink-0" />
                    <span className="text-gray-700">Benchmark against similar properties in your area</span>
                  </li>
                  <li className="flex items-start gap-3">
                    <Target className="w-5 h-5 text-orange-500 mt-0.5 flex-shrink-0" />
                    <span className="text-gray-700">Helps identify if your property is priced competitively</span>
                  </li>
                  <li className="flex items-start gap-3">
                    <CheckCircle className="w-5 h-5 text-red-500 mt-0.5 flex-shrink-0" />
                    <span className="text-gray-700">Market positioning for investment decisions</span>
                  </li>
                </ul>
              </div>
              <div className="bg-gradient-to-br from-purple-50 to-pink-50 p-8 rounded-2xl">
                <img
                  src="https://images.unsplash.com/photo-1590283603385-17ffb3a7f29f?w=500&h=350&fit=crop"
                  alt="Occupancy Trends Analysis"
                  className="w-full h-64 object-cover rounded-xl shadow-lg"
                />
              </div>
            </div>

            {/* 4. Net Rental Yield Calculation */}
            <div className="grid grid-cols-1 lg:grid-cols-2 gap-12 items-center">
              <div className="bg-gradient-to-br from-orange-50 to-red-50 p-8 rounded-2xl order-2 lg:order-1">
                <img
                  src="https://images.unsplash.com/photo-1551288049-bebda4e38f71?w=500&h=350&fit=crop"
                  alt="Yield Calculation"
                  className="w-full h-64 object-cover rounded-xl shadow-lg"
                />
              </div>
              <div className="order-1 lg:order-2">
                <div className="flex items-center mb-4">
                  <div className="bg-[#0056D2] text-white rounded-full w-8 h-8 flex items-center justify-center text-sm font-bold mr-3">4</div>
                  <h3 className="text-2xl font-bold text-gray-900">Yield Projections</h3>
                </div>
                <p className="text-gray-600 mb-6">Future rental yield forecasts assuming 3% annual rental growth over 5 years.</p>
                <ul className="space-y-3">
                  <li className="flex items-start gap-3">
                    <Calendar className="w-5 h-5 text-green-500 mt-0.5 flex-shrink-0" />
                    <span className="text-gray-700">Year 1: Current calculated rental yield</span>
                  </li>
                  <li className="flex items-start gap-3">
                    <TrendingUp className="w-5 h-5 text-blue-500 mt-0.5 flex-shrink-0" />
                    <span className="text-gray-700">Year 3: Projected yield with 9% cumulative growth</span>
                  </li>
                  <li className="flex items-start gap-3">
                    <Target className="w-5 h-5 text-purple-500 mt-0.5 flex-shrink-0" />
                    <span className="text-gray-700">Year 5: Projected yield with 16% cumulative growth</span>
                  </li>
                  <li className="flex items-start gap-3">
                    <BarChart3 className="w-5 h-5 text-orange-500 mt-0.5 flex-shrink-0" />
                    <span className="text-gray-700">Based on historical 3% annual rental escalation</span>
                  </li>
                  <li className="flex items-start gap-3">
                    <DollarSign className="w-5 h-5 text-red-500 mt-0.5 flex-shrink-0" />
                    <span className="text-gray-700">Helps plan long-term investment returns</span>
                  </li>
                </ul>
              </div>
            </div>

            {/* 5. Locality Comparison */}
            <div className="grid grid-cols-1 lg:grid-cols-2 gap-12 items-center">
              <div>
                <div className="flex items-center mb-4">
                  <div className="bg-[#0056D2] text-white rounded-full w-8 h-8 flex items-center justify-center text-sm font-bold mr-3">5</div>
                  <h3 className="text-2xl font-bold text-gray-900">Property Input Factors</h3>
                </div>
                <p className="text-gray-600 mb-6">Key property details that influence your rental yield calculation.</p>
                <ul className="space-y-3">
                  <li className="flex items-start gap-3">
                    <MapPin className="w-5 h-5 text-green-500 mt-0.5 flex-shrink-0" />
                    <span className="text-gray-700">City and Locality selection for market data</span>
                  </li>
                  <li className="flex items-start gap-3">
                    <Home className="w-5 h-5 text-blue-500 mt-0.5 flex-shrink-0" />
                    <span className="text-gray-700">Property type and BHK configuration</span>
                  </li>
                  <li className="flex items-start gap-3">
                    <BarChart3 className="w-5 h-5 text-purple-500 mt-0.5 flex-shrink-0" />
                    <span className="text-gray-700">Built-up area in square feet</span>
                  </li>
                  <li className="flex items-start gap-3">
                    <DollarSign className="w-5 h-5 text-orange-500 mt-0.5 flex-shrink-0" />
                    <span className="text-gray-700">Purchase price for ROI calculation</span>
                  </li>
                  <li className="flex items-start gap-3">
                    <Star className="w-5 h-5 text-yellow-500 mt-0.5 flex-shrink-0" />
                    <span className="text-gray-700">Furnishing status and property age adjustments</span>
                  </li>
                </ul>
              </div>
              <div className="bg-gradient-to-br from-teal-50 to-cyan-50 p-8 rounded-2xl">
                <img
                  src="https://images.unsplash.com/photo-1449824913935-59a10b8d2000?w=500&h=350&fit=crop"
                  alt="Locality Comparison"
                  className="w-full h-64 object-cover rounded-xl shadow-lg"
                />
              </div>
            </div>

            {/* 6. Break-Even & Return Forecast */}
            <div className="grid grid-cols-1 lg:grid-cols-2 gap-12 items-center">
              <div className="bg-gradient-to-br from-indigo-50 to-purple-50 p-8 rounded-2xl order-2 lg:order-1">
                <img
                  src="https://images.unsplash.com/photo-1460925895917-afdab827c52f?w=500&h=350&fit=crop"
                  alt="Investment Forecast"
                  className="w-full h-64 object-cover rounded-xl shadow-lg"
                />
              </div>
              <div className="order-1 lg:order-2">
                <div className="flex items-center mb-4">
                  <div className="bg-[#0056D2] text-white rounded-full w-8 h-8 flex items-center justify-center text-sm font-bold mr-3">6</div>
                  <h3 className="text-2xl font-bold text-gray-900">PDF Report Download</h3>
                </div>
                <p className="text-gray-600 mb-6">Generate and download a comprehensive PDF report with all your rental yield analysis.</p>
                <ul className="space-y-3">
                  <li className="flex items-start gap-3">
                    <CheckCircle className="w-5 h-5 text-green-500 mt-0.5 flex-shrink-0" />
                    <span className="text-gray-700">Complete property details and specifications</span>
                  </li>
                  <li className="flex items-start gap-3">
                    <DollarSign className="w-5 h-5 text-blue-500 mt-0.5 flex-shrink-0" />
                    <span className="text-gray-700">Monthly rent, annual income, and yield percentage</span>
                  </li>
                  <li className="flex items-start gap-3">
                    <BarChart3 className="w-5 h-5 text-purple-500 mt-0.5 flex-shrink-0" />
                    <span className="text-gray-700">Market comparison and performance rating</span>
                  </li>
                  <li className="flex items-start gap-3">
                    <TrendingUp className="w-5 h-5 text-orange-500 mt-0.5 flex-shrink-0" />
                    <span className="text-gray-700">5-year yield projections with growth assumptions</span>
                  </li>
                  <li className="flex items-start gap-3">
                    <Target className="w-5 h-5 text-red-500 mt-0.5 flex-shrink-0" />
                    <span className="text-gray-700">Professional format with logo and branding</span>
                  </li>
                </ul>
              </div>
            </div>

            {/* Final Rental Investment Dashboard */}
            <div className="bg-[#0056D2] text-white p-12 rounded-2xl text-center">
              <div className="flex items-center justify-center mb-6">
                <div className="bg-white text-[#0056D2] rounded-full w-12 h-12 flex items-center justify-center text-lg font-bold mr-4">₹</div>
                <h3 className="text-3xl font-bold">Rental Yield Calculator</h3>
              </div>
              <p className="text-xl text-blue-100 mb-8 max-w-3xl mx-auto">
                Calculate rental income, yield percentage, market comparison, and future projections with downloadable PDF report
              </p>
              <div className="grid grid-cols-2 md:grid-cols-3 lg:grid-cols-6 gap-6">
                <div className="bg-white/10 p-4 rounded-lg">
                  <DollarSign className="w-8 h-8 mx-auto mb-2" />
                  <p className="text-sm font-medium">Monthly Rent</p>
                </div>
                <div className="bg-white/10 p-4 rounded-lg">
                  <BarChart3 className="w-8 h-8 mx-auto mb-2" />
                  <p className="text-sm font-medium">Rental Yield %</p>
                </div>
                <div className="bg-white/10 p-4 rounded-lg">
                  <TrendingUp className="w-8 h-8 mx-auto mb-2" />
                  <p className="text-sm font-medium">Market Compare</p>
                </div>
                <div className="bg-white/10 p-4 rounded-lg">
                  <Calendar className="w-8 h-8 mx-auto mb-2" />
                  <p className="text-sm font-medium">Projections</p>
                </div>
                <div className="bg-white/10 p-4 rounded-lg">
                  <MapPin className="w-8 h-8 mx-auto mb-2" />
                  <p className="text-sm font-medium">Real Data</p>
                </div>
                <div className="bg-white/10 p-4 rounded-lg">
                  <Target className="w-8 h-8 mx-auto mb-2" />
                  <p className="text-sm font-medium">PDF Report</p>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </>
  );
}