import React from "react";
import {
  Shield,
  FileText,
  AlertTriangle,
  CheckCircle,
  Target,
  ArrowRight,
} from "lucide-react";
import { Button } from "../ui/button";

export function RiskCompliance() {
  const handleStartAssessment = () => {
    window.location.href = '/advisory/risk-compliance';
  };

  return (
    <>
      {/* Hero Section */}
      <div className="bg-gray-50 py-16">
        <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
          <div className="text-center mb-12">
            <h2 className="text-3xl font-bold text-gray-900 mb-4">
              Risk & Compliance Checker
            </h2>
            <p className="text-lg text-gray-600 max-w-3xl mx-auto">
              Comprehensive risk analysis with legal compliance verification, document validation, and RERA status checks
            </p>
          </div>

          {/* Quick Start Card */}
          <div className="bg-white rounded-2xl shadow-lg p-8 mb-8 max-w-4xl mx-auto">
            <div className="text-center mb-8">
              <Shield className="w-16 h-16 text-[#0056D2] mx-auto mb-4" />
              <h3 className="text-2xl font-bold text-gray-900 mb-4">
                Start Your Property Risk Assessment
              </h3>
              <p className="text-gray-600 mb-6">
                Get a detailed analysis of legal risks, missing documents, encumbrances, and RERA compliance
              </p>
              
              <Button 
                onClick={handleStartAssessment}
                size="lg"
                className="bg-[#0056D2] hover:bg-[#003d9a] text-lg px-8 py-3"
              >
                <Shield className="w-5 h-5 mr-2" />
                Start Risk Assessment
                <ArrowRight className="w-5 h-5 ml-2" />
              </Button>
            </div>

            {/* Features Preview */}
            <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6">
              <div className="text-center p-4 bg-blue-50 rounded-lg">
                <FileText className="w-8 h-8 text-blue-600 mx-auto mb-2" />
                <h4 className="font-semibold text-gray-900 mb-1">Document Upload</h4>
                <p className="text-sm text-gray-600">Upload & verify all required documents</p>
              </div>
              
              <div className="text-center p-4 bg-green-50 rounded-lg">
                <CheckCircle className="w-8 h-8 text-green-600 mx-auto mb-2" />
                <h4 className="font-semibold text-gray-900 mb-1">RERA Check</h4>
                <p className="text-sm text-gray-600">Verify RERA registration & compliance</p>
              </div>
              
              <div className="text-center p-4 bg-yellow-50 rounded-lg">
                <AlertTriangle className="w-8 h-8 text-yellow-600 mx-auto mb-2" />
                <h4 className="font-semibold text-gray-900 mb-1">Encumbrance Check</h4>
                <p className="text-sm text-gray-600">Detect loans & financial liabilities</p>
              </div>
              
              <div className="text-center p-4 bg-purple-50 rounded-lg">
                <Target className="w-8 h-8 text-purple-600 mx-auto mb-2" />
                <h4 className="font-semibold text-gray-900 mb-1">Risk Score</h4>
                <p className="text-sm text-gray-600">Get comprehensive risk rating</p>
              </div>
            </div>
          </div>
        </div>
      </div>

      {/* Features Overview */}
      <div className="bg-white py-12">
        <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
          <div className="text-center mb-12">
            <h3 className="text-2xl font-bold text-gray-900 mb-4">Comprehensive Risk Analysis</h3>
            <p className="text-gray-600 max-w-2xl mx-auto">
              Our multi-step verification process ensures you have complete visibility into property risks before making investment decisions.
            </p>
          </div>

          <div className="grid grid-cols-1 lg:grid-cols-2 gap-12 items-center mb-12">
            <div>
              <h4 className="text-xl font-bold text-gray-900 mb-6">What We Verify</h4>
              <ul className="space-y-4">
                <li className="flex items-start gap-3">
                  <CheckCircle className="w-5 h-5 text-green-500 mt-0.5 flex-shrink-0" />
                  <div>
                    <span className="font-medium text-gray-900">Document Completeness</span>
                    <p className="text-sm text-gray-600">Sale deed, Khata/RTC, tax receipts, EC, RERA certificate</p>
                  </div>
                </li>
                <li className="flex items-start gap-3">
                  <CheckCircle className="w-5 h-5 text-green-500 mt-0.5 flex-shrink-0" />
                  <div>
                    <span className="font-medium text-gray-900">RERA Compliance</span>
                    <p className="text-sm text-gray-600">Registration status, validity, completion percentage</p>
                  </div>
                </li>
                <li className="flex items-start gap-3">
                  <CheckCircle className="w-5 h-5 text-green-500 mt-0.5 flex-shrink-0" />
                  <div>
                    <span className="font-medium text-gray-900">Ownership Verification</span>
                    <p className="text-sm text-gray-600">Title clarity, document consistency, legal disputes</p>
                  </div>
                </li>
                <li className="flex items-start gap-3">
                  <AlertTriangle className="w-5 h-5 text-red-500 mt-0.5 flex-shrink-0" />
                  <div>
                    <span className="font-medium text-gray-900">Encumbrance Detection</span>
                    <p className="text-sm text-gray-600">Bank loans, mortgages, financial liabilities</p>
                  </div>
                </li>
              </ul>
            </div>
            <div className="bg-gradient-to-br from-blue-50 to-indigo-50 p-8 rounded-2xl">
              <img
                src="https://images.unsplash.com/photo-1554224155-8d04cb21cd6c?w=500&h=350&fit=crop"
                alt="Risk Assessment Process"
                className="w-full h-64 object-cover rounded-xl shadow-lg"
              />
            </div>
          </div>

          {/* CTA Section */}
          <div className="bg-[#0056D2] text-white p-8 rounded-2xl text-center">
            <h3 className="text-2xl font-bold mb-4">Ready to Assess Your Property Risk?</h3>
            <p className="text-blue-100 mb-6 max-w-2xl mx-auto">
              Get a comprehensive risk analysis with legal compliance verification, document validation, and expert recommendations.
            </p>
            <Button 
              onClick={handleStartAssessment}
              size="lg" 
              className="bg-white text-[#0056D2] hover:bg-gray-100"
            >
              <Shield className="w-5 h-5 mr-2" />
              Start Risk Assessment
              <ArrowRight className="w-5 h-5 ml-2" />
            </Button>
            <div className="mt-4">
              <p className="text-sm text-blue-200">
                ✓ Multi-step verification • ✓ Expert analysis • ✓ Detailed PDF report • ✓ Risk recommendations
              </p>
            </div>
          </div>
        </div>
      </div>
    </>
  );
}