import React from 'react';
import { Bookmark, Heart, Eye, Share2 } from 'lucide-react';

const SavedProperties: React.FC = () => {
  const savedProperties = [
    {
      id: '1',
      title: '3BHK Luxury Apartment',
      price: '₹50,00,000',
      location: 'Bandra West, Mumbai',
      image: 'https://images.unsplash.com/photo-1560518883-ce09059eeffa?ixlib=rb-4.0.3&auto=format&fit=crop&w=1000&q=80',
      savedDate: '2024-01-15'
    },
    {
      id: '2',
      title: '2BHK Modern Flat',
      price: '₹35,00,000',
      location: 'Andheri West, Mumbai',
      image: 'https://images.unsplash.com/photo-1560518883-ce09059eeffa?ixlib=rb-4.0.3&auto=format&fit=crop&w=1000&q=80',
      savedDate: '2024-01-10'
    }
  ];

  return (
    <div className="space-y-6">
      <div className="bg-white rounded-xl shadow-sm p-6">
        <h2 className="text-2xl font-bold text-gray-900 mb-2">Saved Properties</h2>
        <p className="text-gray-600 mb-6">Properties you've bookmarked for later viewing</p>

        <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
          {savedProperties.map((property) => (
            <div key={property.id} className="bg-white border border-gray-200 rounded-lg overflow-hidden hover:shadow-lg transition-shadow">
              <div className="relative">
                <img
                  src={property.image}
                  alt={property.title}
                  className="w-full h-48 object-cover"
                />
                <button className="absolute top-3 right-3 p-2 bg-white/90 rounded-full hover:bg-white transition-colors">
                  <Bookmark className="w-4 h-4 text-[#0056D2] fill-current" />
                </button>
              </div>
              
              <div className="p-4">
                <h3 className="font-semibold text-gray-900 mb-2">{property.title}</h3>
                <p className="text-2xl font-bold text-[#0056D2] mb-2">{property.price}</p>
                <p className="text-gray-600 text-sm mb-3">{property.location}</p>
                <p className="text-xs text-gray-500 mb-4">Saved on {property.savedDate}</p>
                
                <div className="flex gap-2">
                  <button className="flex-1 flex items-center justify-center gap-2 px-3 py-2 bg-[#0056D2] text-white rounded-lg hover:bg-[#0041A3] transition-colors">
                    <Eye className="w-4 h-4" />
                    View Details
                  </button>
                  <button className="px-3 py-2 border border-gray-300 text-gray-700 rounded-lg hover:bg-gray-50 transition-colors">
                    <Share2 className="w-4 h-4" />
                  </button>
                </div>
              </div>
            </div>
          ))}
        </div>

        {savedProperties.length === 0 && (
          <div className="text-center py-12">
            <Bookmark className="w-16 h-16 text-gray-300 mx-auto mb-4" />
            <h3 className="text-lg font-medium text-gray-900 mb-2">No saved properties</h3>
            <p className="text-gray-500">Properties you bookmark will appear here</p>
          </div>
        )}
      </div>
    </div>
  );
};

export default SavedProperties;