import React from 'react';
import { History, Search, MapPin, Filter, Clock } from 'lucide-react';

const SearchHistory: React.FC = () => {
  const searchHistory = [
    {
      id: '1',
      query: '3BHK apartment in Bandra',
      location: 'Bandra West, Mumbai',
      filters: { priceRange: '40L-60L', bedrooms: '3', propertyType: 'Apartment' },
      results: 24,
      searchDate: '2024-01-20',
      searchTime: '10:30 AM'
    },
    {
      id: '2',
      query: 'Villa near Powai Lake',
      location: 'Powai, Mumbai',
      filters: { priceRange: '80L-1.2Cr', bedrooms: '4+', propertyType: 'Villa' },
      results: 8,
      searchDate: '2024-01-19',
      searchTime: '2:15 PM'
    },
    {
      id: '3',
      query: 'Commercial space Andheri',
      location: 'Andheri East, Mumbai',
      filters: { priceRange: '50L-80L', propertyType: 'Commercial' },
      results: 15,
      searchDate: '2024-01-18',
      searchTime: '11:45 AM'
    }
  ];

  return (
    <div className="space-y-6">
      <div className="bg-white rounded-xl shadow-sm p-6">
        <h2 className="text-2xl font-bold text-gray-900 mb-2">Search History</h2>
        <p className="text-gray-600 mb-6">Your recent property searches and filters</p>

        <div className="space-y-4">
          {searchHistory.map((search) => (
            <div key={search.id} className="bg-gray-50 border border-gray-200 rounded-lg p-4 hover:bg-gray-100 transition-colors">
              <div className="flex items-start justify-between mb-3">
                <div className="flex-1">
                  <div className="flex items-center gap-2 mb-2">
                    <Search className="w-4 h-4 text-[#0056D2]" />
                    <h3 className="font-semibold text-gray-900">{search.query}</h3>
                  </div>
                  
                  <div className="flex items-center text-gray-600 text-sm mb-2">
                    <MapPin className="w-4 h-4 mr-1" />
                    {search.location}
                  </div>
                  
                  <div className="flex items-center gap-4 text-sm text-gray-600">
                    <div className="flex items-center gap-1">
                      <Filter className="w-4 h-4" />
                      <span>Filters:</span>
                    </div>
                    <span className="bg-white px-2 py-1 rounded text-xs">{search.filters.priceRange}</span>
                    <span className="bg-white px-2 py-1 rounded text-xs">{search.filters.bedrooms} BHK</span>
                    <span className="bg-white px-2 py-1 rounded text-xs">{search.filters.propertyType}</span>
                  </div>
                </div>
                
                <div className="text-right">
                  <div className="text-sm font-medium text-[#0056D2] mb-1">
                    {search.results} results
                  </div>
                  <div className="flex items-center text-xs text-gray-500">
                    <Clock className="w-3 h-3 mr-1" />
                    {search.searchDate} at {search.searchTime}
                  </div>
                </div>
              </div>
              
              <div className="flex gap-2">
                <button className="px-3 py-1 bg-[#0056D2] text-white rounded text-sm hover:bg-[#0041A3] transition-colors">
                  Search Again
                </button>
                <button className="px-3 py-1 border border-gray-300 text-gray-700 rounded text-sm hover:bg-white transition-colors">
                  View Results
                </button>
              </div>
            </div>
          ))}
        </div>

        {searchHistory.length === 0 && (
          <div className="text-center py-12">
            <History className="w-16 h-16 text-gray-300 mx-auto mb-4" />
            <h3 className="text-lg font-medium text-gray-900 mb-2">No search history</h3>
            <p className="text-gray-500">Your property searches will appear here</p>
          </div>
        )}
      </div>
    </div>
  );
};

export default SearchHistory;