export const mockClients = [
  {
    id: '1',
    name: 'John Doe',
    email: 'john@example.com',
    phone: '+91-9876543210',
    status: 'active',
    properties: 2,
    totalValue: 5000000,
    propertyIds: ['1', '2']
  },
  {
    id: '2',
    name: 'Jane Smith',
    email: 'jane@example.com',
    phone: '+91-9876543211',
    status: 'active',
    properties: 1,
    totalValue: 2500000,
    propertyIds: ['3']
  }
];

export const properties = [
  {
    id: '1',
    title: '3BHK Luxury Apartment',
    price: 5000000,
    location: 'Bandra West',
    type: 'apartment',
    status: 'active'
  },
  {
    id: '2',
    title: '2BHK Modern Flat',
    price: 2500000,
    location: 'Andheri West',
    type: 'apartment',
    status: 'sold'
  }
];

export const mockContracts = [
  {
    id: '1',
    clientId: '1',
    propertyId: '1',
    type: 'sale',
    status: 'active',
    amount: 5000000,
    date: '2024-01-15',
    name: 'Sale Agreement - Property 1',
    uploadDate: '2024-01-15'
  },
  {
    id: '2',
    clientId: '2',
    propertyId: '2',
    type: 'sale',
    status: 'completed',
    amount: 2500000,
    date: '2024-02-01',
    name: 'Sale Agreement - Property 2',
    uploadDate: '2024-02-01'
  }
];

export const mockCommissions = [
  {
    id: '1',
    propertyTitle: '3BHK Luxury Apartment',
    propertyId: '1',
    clientName: 'John Doe',
    clientId: '1',
    amount: 150000,
    percentage: 3,
    propertyValue: 5000000,
    transactionType: 'Sale',
    date: '2024-01-15',
    dueDate: '2024-01-30',
    paidDate: '2024-01-28',
    status: 'Paid',
    priority: 'High',
    paymentMethod: 'Bank Transfer',
    invoiceNumber: 'INV-2024-001',
    taxDeducted: 15000,
    netAmount: 135000,
    location: 'Bandra West, Mumbai',
    propertyType: 'Apartment',
    dealClosureTime: 45,
    leadSource: 'Website',
    notes: 'Premium client, quick closure'
  },
  {
    id: '2',
    propertyTitle: '2BHK Modern Flat',
    propertyId: '2',
    clientName: 'Jane Smith',
    clientId: '2',
    amount: 75000,
    percentage: 3,
    propertyValue: 2500000,
    transactionType: 'Sale',
    date: '2024-02-01',
    dueDate: '2024-02-15',
    paidDate: null,
    status: 'Pending',
    priority: 'Medium',
    paymentMethod: 'Pending',
    invoiceNumber: 'INV-2024-002',
    taxDeducted: 7500,
    netAmount: 67500,
    location: 'Andheri West, Mumbai',
    propertyType: 'Apartment',
    dealClosureTime: 30,
    leadSource: 'Referral',
    notes: 'Follow up required for payment'
  },
  {
    id: '3',
    propertyTitle: 'Commercial Office Space',
    propertyId: '3',
    clientName: 'Tech Solutions Pvt Ltd',
    clientId: '3',
    amount: 200000,
    percentage: 2.5,
    propertyValue: 8000000,
    transactionType: 'Lease',
    date: '2024-01-20',
    dueDate: '2024-02-05',
    paidDate: '2024-02-03',
    status: 'Paid',
    priority: 'High',
    paymentMethod: 'Cheque',
    invoiceNumber: 'INV-2024-003',
    taxDeducted: 20000,
    netAmount: 180000,
    location: 'BKC, Mumbai',
    propertyType: 'Commercial',
    dealClosureTime: 60,
    leadSource: 'Cold Call',
    notes: 'Corporate client, annual lease'
  },
  {
    id: '4',
    propertyTitle: 'Luxury Villa',
    propertyId: '4',
    clientName: 'Rajesh Kumar',
    clientId: '4',
    amount: 300000,
    percentage: 2,
    propertyValue: 15000000,
    transactionType: 'Sale',
    date: '2024-01-10',
    dueDate: '2024-01-25',
    paidDate: null,
    status: 'Overdue',
    priority: 'Urgent',
    paymentMethod: 'Pending',
    invoiceNumber: 'INV-2024-004',
    taxDeducted: 30000,
    netAmount: 270000,
    location: 'Juhu, Mumbai',
    propertyType: 'Villa',
    dealClosureTime: 90,
    leadSource: 'Social Media',
    notes: 'High-value deal, payment overdue'
  },
  {
    id: '5',
    propertyTitle: 'Studio Apartment',
    propertyId: '5',
    clientName: 'Priya Sharma',
    clientId: '5',
    amount: 45000,
    percentage: 3,
    propertyValue: 1500000,
    transactionType: 'Rent',
    date: '2024-02-05',
    dueDate: '2024-02-20',
    paidDate: null,
    status: 'Processing',
    priority: 'Low',
    paymentMethod: 'UPI',
    invoiceNumber: 'INV-2024-005',
    taxDeducted: 4500,
    netAmount: 40500,
    location: 'Powai, Mumbai',
    propertyType: 'Apartment',
    dealClosureTime: 15,
    leadSource: 'Walk-in',
    notes: 'First-time buyer, quick rental'
  }
];

export const commissionStats = {
  totalEarned: 770000,
  totalPaid: 485000,
  totalPending: 285000,
  thisMonth: 120000,
  lastMonth: 350000,
  avgDealSize: 154000,
  avgClosureTime: 48,
  conversionRate: 78,
  topPerformingType: 'Apartment',
  monthlyTarget: 200000,
  yearlyTarget: 2400000,
  achievementRate: 85
};

export const commissionTrends = [
  { month: 'Oct', amount: 180000, deals: 3 },
  { month: 'Nov', amount: 220000, deals: 4 },
  { month: 'Dec', amount: 350000, deals: 6 },
  { month: 'Jan', amount: 485000, deals: 8 },
  { month: 'Feb', amount: 120000, deals: 2 }
];

export const paymentReminders = [
  {
    id: '4',
    clientName: 'Rajesh Kumar',
    amount: 300000,
    daysOverdue: 12,
    priority: 'Urgent'
  },
  {
    id: '2',
    clientName: 'Jane Smith',
    amount: 75000,
    daysOverdue: 0,
    priority: 'Medium'
  }
];

export const mockAgent = {
  id: '1',
  name: 'Suresh',
  email: 'suresh@example.com'
};

export const mockVisits = [
  {
    id: '1',
    propertyTitle: '3BHK Luxury Apartment',
    clientName: 'John Doe',
    clientPhone: '+91-9876543210',
    date: '2024-01-20',
    time: '10:00',
    status: 'scheduled'
  },
  {
    id: '2',
    propertyTitle: '2BHK Modern Flat',
    clientName: 'Jane Smith',
    clientPhone: '+91-9876543211',
    date: '2024-01-18',
    time: '14:00',
    status: 'completed'
  }
];

export const mockMessages = [
  {
    id: '1',
    clientName: 'Amit Sharma',
    propertyId: 'Property 1',
    message: 'Hi, I am interested in this property',
    timestamp: '2024-01-20T10:00:00Z',
    isAgent: false,
    read: false
  },
  {
    id: '2',
    clientName: 'Amit Sharma',
    propertyId: 'Property 1',
    message: 'Hello! I would be happy to help you with this property.',
    timestamp: '2024-01-20T10:05:00Z',
    isAgent: true,
    read: true
  }
];

export const mockNotifications = [
  {
    id: '1',
    title: 'New inquiry received',
    message: 'John Doe is interested in your property',
    timestamp: '2024-01-20T10:00:00Z',
    read: false
  }
];