import React, { useState, useEffect } from "react";
import { useNavigate } from "react-router-dom";
import {
  Settings, Gavel,
  Home, Heart, History, MessageSquare, Calendar,
  GitCompare, User, LifeBuoy, ChevronLeft, ChevronRight, Bookmark, Building, HomeIcon, FileText, Download, TrendingUp, Calculator, CreditCard, Award, MapPin, FileSignature, Shield, BarChart3, Stamp, Star, Monitor, ShieldCheck, AlertCircle, Wallet, Tag, GraduationCap, Key, DollarSign
} from "lucide-react";
import { getSellerPendingVisits } from "../../api/visitSchedules";

interface BuyerSidebarProps {
  activeSection: string;
  setActiveSection: (section: string) => void;
  isSidebarCollapsed: boolean;
  setIsSidebarCollapsed: (collapsed: boolean) => void;
}

export function BuyerSidebar({ activeSection, setActiveSection, isSidebarCollapsed, setIsSidebarCollapsed }: BuyerSidebarProps) {
  const navigate = useNavigate();
  const [pendingVisitsCount, setPendingVisitsCount] = useState(0);
  const [hasFeatureFlags, setHasFeatureFlags] = useState(false);
  const user = JSON.parse(localStorage.getItem('user') || '{}');

  useEffect(() => {
    const checkFeatureFlags = async () => {
      try {
        const token = localStorage.getItem('access_token');
        const res = await fetch('http://localhost:8090/api/admin/feature-flags/my-flags/', {
          headers: { 'Authorization': `Bearer ${token}` }
        });
        const data = await res.json();
        setHasFeatureFlags(data.flags && data.flags.length > 0);
      } catch (error) {
        console.error('Error checking feature flags:', error);
      }
    };
    checkFeatureFlags();
  }, []);

  useEffect(() => {
    const fetchCounts = async () => {
      try {
        if (user.user_id) {
          const visitsData = await getSellerPendingVisits(user.user_id, 1, 1);
          setPendingVisitsCount(visitsData.total_count);
        }
      } catch (error) {
        console.error('Error fetching counts:', error);
      }
    };

    fetchCounts();
    const interval = setInterval(fetchCounts, 30000);
    return () => clearInterval(interval);
  }, [user.user_id]);

  const navigationItems = [
    { id: "Dashboard", label: "Dashboard", icon: Home },
    { id: "Properties", label: "Properties", icon: Building },
    { id: "BidsNegotiations", label: "Bids & Negotiations", icon: Gavel },
    { id: "Visits", label: "Visits & Itineraries", icon: Calendar, showBadge: true },
    { id: "Insights", label: "Insights & Tools", icon: TrendingUp },
    { id: "Documents", label: "Documents", icon: FileText },
    { id: "Payments", label: "Payments", icon: CreditCard },
    { id: "Settings", label: "Settings", icon: Settings }
  ];

  return (
    <div className={`bg-white shadow-sm border-r fixed left-0 top-0 h-full min-h-screen z-50 transition-all duration-300 flex flex-col ${isSidebarCollapsed ? 'w-20' : 'w-64'
      }`}>
      <div className="p-4">
        <div className="flex items-center gap-3 cursor-pointer" onClick={() => navigate('/')}>
          {!isSidebarCollapsed ? (
            <>
              <img src="/src/assets/logo.jpg" alt="NAL Logo" className="w-12 h-12 rounded-lg object-cover" />
              <div>
                <h1 className="text-lg font-bold text-gray-900">New Age Land</h1>
                <p className="text-xs text-gray-600">User Panel</p>
              </div>
            </>
          ) : (
            <img src="/src/assets/logo.jpg" alt="NAL Logo" className="w-12 h-12 rounded-lg object-cover mx-auto" />
          )}
        </div>
      </div>

      <nav className="px-2 flex-1 overflow-y-auto" style={{ scrollbarWidth: 'none', msOverflowStyle: 'none' }}>
        <div className="space-y-1">
        {navigationItems.map((item, index) => {
          const IconComponent = item.icon;
          const isActive = activeSection === item.id;
          
          return (
            <button
              key={item.id}
              onClick={() => setActiveSection(item.id)}
              className={`w-full flex items-center px-3 py-4 text-sm font-medium rounded-lg transition-colors group relative ${
                  isActive
                    ? "bg-[#0056D2] text-white shadow-sm"
                    : "text-gray-700 hover:bg-gray-100 hover:text-[#0056D2]"
                }`}
              >
                <IconComponent className={`w-5 h-5 ${isSidebarCollapsed ? 'mx-auto' : 'mr-3'}`} />
                {!isSidebarCollapsed && (
                  <span className="whitespace-nowrap">{item.label}</span>
                )}
                {item.showBadge && pendingVisitsCount > 0 && (
                  <div className={`${isSidebarCollapsed ? 'absolute -top-1 -right-1' : 'ml-auto'} bg-red-500 text-white text-xs rounded-full min-w-[20px] h-5 flex items-center justify-center px-1`}>
                    {pendingVisitsCount > 99 ? '99+' : pendingVisitsCount}
                  </div>
                )}
                {isActive && !isSidebarCollapsed && (
                  <div className="absolute right-0 top-0 bottom-0 w-1 bg-[#00BFA6] rounded-l"></div>
                )}
              </button>
            );
          })}
        </div>
      </nav>
    </div>
  );
}