import React, { useState } from 'react';
import InvoiceList from '../../finance/InvoiceList';
import RefundRequestModal from '../../finance/RefundRequestModal';

const mockInvoices = [
    { id: '1', number: 'INV-2024-001', date: '2024-02-01', amount: 120.00, status: 'paid', pdf_url: '#' },
    { id: '2', number: 'INV-2024-002', date: '2024-01-15', amount: 50.00, status: 'refunded', pdf_url: '#' },
];

const InvoicesPage: React.FC = () => {
    const [selectedInvoice, setSelectedInvoice] = useState<string | null>(null);
    const [isRefundModalOpen, setIsRefundModalOpen] = useState(false);

    const handleDownload = (id: string) => {
        console.log('Download', id);
        // Logic to download PDF
    };

    const handleView = (id: string) => {
        // In a real app, this might navigate to details
        // For now, let's open the Refund Modal for demo purposes if needed, or just log
        console.log('View', id);
        setSelectedInvoice(id);
        // setIsRefundModalOpen(true); // Uncomment to test modal on view
    };

    const handleRefundSubmit = (reason: string, details: string) => {
        console.log('Refund Requested', { invoiceId: selectedInvoice, reason, details });
        // API Call here
    };

    return (
        <div className="p-6 space-y-6 bg-gray-50 min-h-screen">
            <div className="flex justify-between items-center mb-6">
                <div>
                    <h1 className="text-2xl font-bold text-gray-900">My Invoices</h1>
                    <p className="text-sm text-gray-500">View and download your billing history.</p>
                </div>
            </div>

            <InvoiceList
                invoices={mockInvoices as any}
                onDownload={handleDownload}
                onView={handleView}
            />

            {/* Button to trigger refund (Demo) - In real app, this would be on Details Page */}
            <div className="mt-8 p-4 bg-gray-100 rounded-lg text-center">
                <p className="text-sm text-gray-500 mb-2">Need a refund for a recent purchase?</p>
                <button
                    onClick={() => { setSelectedInvoice('1'); setIsRefundModalOpen(true); }}
                    className="text-sm font-medium text-red-600 hover:text-red-700 underline"
                >
                    Request Refund (Demo)
                </button>
            </div>

            {selectedInvoice && (
                <RefundRequestModal
                    invoiceId={mockInvoices.find(i => i.id === selectedInvoice)?.number || ''}
                    isOpen={isRefundModalOpen}
                    onClose={() => setIsRefundModalOpen(false)}
                    onSubmit={handleRefundSubmit}
                />
            )}
        </div>
    );
};

export default InvoicesPage;
