import React from 'react';
import UsageMeter from '../../finance/UsageMeter';
import { ArrowLeft } from 'lucide-react';
import { useNavigate } from 'react-router-dom';

const UsagePage: React.FC = () => {
    const navigate = useNavigate();

    const myStats = [
        { feature_slug: 'api_calls', count: 850, limit: 1000, reset_at: '2024-03-01' },
        { feature_slug: 'property_listings', count: 2, limit: 5, reset_at: '2024-03-01' },
        { feature_slug: 'storage_gb', count: 4.5, limit: 10, reset_at: '2024-03-01' },
    ];

    return (
        <div className="p-6 space-y-6 bg-gray-50 min-h-screen">
            <div className="flex items-center gap-4 mb-6">
                <button
                    onClick={() => navigate(-1)}
                    className="p-2 hover:bg-white rounded-full transition-colors"
                >
                    <ArrowLeft className="w-5 h-5 text-gray-500" />
                </button>
                <div>
                    <h1 className="text-2xl font-bold text-gray-900">API & Usage</h1>
                    <p className="text-sm text-gray-500">Monitor your current plan consumption.</p>
                </div>
            </div>

            <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
                {myStats.map((stat) => (
                    <UsageMeter
                        key={stat.feature_slug}
                        stats={stat}
                        onUpgrade={() => console.log('Upgrade Clicked')}
                    />
                ))}
            </div>
        </div>
    );
};

export default UsagePage;
