import React from 'react';
import { CheckCircle, Clock, XCircle, AlertCircle, Circle } from 'lucide-react';
import { Badge } from '../ui/badge';

interface KYCStatusBadgeProps {
  status: string;
  isVerified: boolean;
}

export const KYCStatusBadge: React.FC<KYCStatusBadgeProps> = ({ status, isVerified }) => {
  const statusConfig = {
    approved: {
      icon: CheckCircle,
      color: 'bg-green-500',
      textColor: 'text-green-700',
      bgColor: 'bg-green-50',
      text: 'Verified',
      borderColor: 'border-green-200'
    },
    submitted: {
      icon: Clock,
      color: 'bg-blue-500',
      textColor: 'text-blue-700',
      bgColor: 'bg-blue-50',
      text: 'Under Review',
      borderColor: 'border-blue-200'
    },
    under_review: {
      icon: Clock,
      color: 'bg-yellow-500',
      textColor: 'text-yellow-700',
      bgColor: 'bg-yellow-50',
      text: 'Under Review',
      borderColor: 'border-yellow-200'
    },
    rejected: {
      icon: XCircle,
      color: 'bg-red-500',
      textColor: 'text-red-700',
      bgColor: 'bg-red-50',
      text: 'Rejected',
      borderColor: 'border-red-200'
    },
    resubmission_required: {
      icon: AlertCircle,
      color: 'bg-orange-500',
      textColor: 'text-orange-700',
      bgColor: 'bg-orange-50',
      text: 'Action Required',
      borderColor: 'border-orange-200'
    },
    pending: {
      icon: Circle,
      color: 'bg-gray-500',
      textColor: 'text-gray-700',
      bgColor: 'bg-gray-50',
      text: 'Not Completed',
      borderColor: 'border-gray-200'
    }
  };

  const config = statusConfig[status as keyof typeof statusConfig] || statusConfig.pending;
  const Icon = config.icon;

  return (
    <div className={`inline-flex items-center gap-2 px-4 py-2 rounded-full border ${config.bgColor} ${config.borderColor}`}>
      <Icon className={`w-5 h-5 ${config.textColor}`} />
      <span className={`font-semibold ${config.textColor}`}>{config.text}</span>
    </div>
  );
};
