import React, { useState } from 'react';
import { CompetitorAnalyticsModal } from './CompetitorAnalyticsModal';
import { BarChart3 } from 'lucide-react';

export const CompetitorAnalyticsTest: React.FC = () => {
  const [showModal, setShowModal] = useState(false);

  const testPropertyData = {
    city: 'Mumbai',
    locality: 'Bandra West',
    property_type: 'apartment',
    listing_type: 'sell',
    property_condition: 'resale',
    bedrooms: 3,
    built_up_area: 1200,
    sale_price: 15000000,
    listed_date: new Date().toISOString().split('T')[0]
  };

  return (
    <div className="p-8 bg-gray-50 min-h-screen">
      <div className="max-w-2xl mx-auto">
        <div className="bg-white rounded-lg shadow-lg p-6">
          <h1 className="text-2xl font-bold text-gray-900 mb-4">
            Competitor Analytics Test
          </h1>
          
          <div className="bg-blue-50 rounded-lg p-4 mb-6">
            <h3 className="font-semibold text-blue-900 mb-2">Test Property Data:</h3>
            <div className="text-sm text-blue-800 space-y-1">
              <p><strong>Location:</strong> {testPropertyData.locality}, {testPropertyData.city}</p>
              <p><strong>Type:</strong> {testPropertyData.property_type}</p>
              <p><strong>Listing:</strong> {testPropertyData.listing_type}</p>
              <p><strong>Bedrooms:</strong> {testPropertyData.bedrooms}</p>
              <p><strong>Area:</strong> {testPropertyData.built_up_area} sq ft</p>
              <p><strong>Price:</strong> ₹{testPropertyData.sale_price.toLocaleString()}</p>
            </div>
          </div>

          <button
            onClick={() => setShowModal(true)}
            className="w-full px-6 py-3 bg-gradient-to-r from-blue-600 to-purple-600 text-white rounded-lg hover:from-blue-700 hover:to-purple-700 transition-all duration-200 flex items-center justify-center space-x-2 shadow-lg hover:shadow-xl transform hover:scale-105"
          >
            <BarChart3 className="w-5 h-5" />
            <span className="font-semibold">Test Competitor Analytics</span>
          </button>

          <div className="mt-4 text-sm text-gray-600">
            <p>This will open the Competitor Analytics modal with test data.</p>
            <p>The modal should analyze the property pricing and show market insights.</p>
          </div>
        </div>
      </div>

      <CompetitorAnalyticsModal
        isOpen={showModal}
        onClose={() => setShowModal(false)}
        propertyData={testPropertyData}
      />
    </div>
  );
};