import React from 'react';
import { Button } from '../ui/button';
import { HeatmapMode } from './types';
import { BarChart3, DollarSign, Calculator, Zap } from 'lucide-react';

interface HeatmapControlsProps {
  mode: HeatmapMode;
  onModeChange: (mode: HeatmapMode) => void;
}

export function HeatmapControls({ mode, onModeChange }: HeatmapControlsProps) {
  const modes = [
    { key: 'density', label: 'Property Density', icon: BarChart3 },
    { key: 'price', label: 'Price Ranges', icon: DollarSign },
    { key: 'price_per_sqft', label: 'Price/Sqft', icon: Calculator },
    { key: 'market_velocity', label: 'Market Velocity', icon: Zap }
  ];

  return (
    <div className="flex flex-wrap gap-2 mb-4">
      {modes.map(({ key, label, icon: Icon }) => (
        <Button
          key={key}
          variant={mode === key ? 'default' : 'outline'}
          onClick={() => onModeChange(key as HeatmapMode)}
          className={`text-sm flex items-center gap-2 ${
            mode === key
              ? 'bg-[#0056D2] hover:bg-[#0041A3] text-white'
              : 'border-[#0056D2] text-[#0056D2] hover:bg-[#0056D2] hover:text-white'
          }`}
        >
          <Icon className="w-4 h-4" />
          {label}
        </Button>
      ))}
    </div>
  );
}