import React from 'react';
import { Info } from 'lucide-react';

export function HeatmapInterpretation() {
  return (
    <div className="bg-white rounded-lg p-6 shadow-sm border border-gray-200 mt-6">
      <div className="flex items-center gap-2 mb-4">
        <Info className="w-5 h-5 text-[#0056D2]" />
        <h3 className="text-lg font-semibold text-gray-900">Heatmap Interpretation</h3>
      </div>
      
      <p className="text-gray-600 mb-6 leading-relaxed">
        Our heatmap uses a color-coded system to help users quickly understand property trends and activity levels across different locations:
      </p>

      <div className="space-y-4 mb-6">
        <div className="flex items-start gap-3">
          <div>
            <h4 className="font-medium mb-1 flex items-center gap-2">
              <div className="w-6 h-6 bg-green-500 rounded-full border-2 border-white shadow-lg"></div>
              <span className="text-gray-900">Green</span>
            </h4>
            <p className="text-sm text-gray-600 leading-relaxed">
              Indicates low activity or lower property prices. These areas are generally calmer and less competitive.
            </p>
          </div>
        </div>

        <div className="flex items-start gap-3">
          <div>
            <h4 className="font-medium mb-1 flex items-center gap-2">
              <div className="w-6 h-6 bg-yellow-500 rounded-full border-2 border-white shadow-lg"></div>
              <span className="text-gray-900">Yellow / Orange</span>
            </h4>
            <p className="text-sm text-gray-600 leading-relaxed">
              Represents moderate activity. Property availability and pricing fall in the mid-range.
            </p>
          </div>
        </div>

        <div className="flex items-start gap-3">
          <div>
            <h4 className="font-medium mb-1 flex items-center gap-2">
              <div className="w-6 h-6 bg-red-500 rounded-full border-2 border-white shadow-lg"></div>
              <span className="text-gray-900">Red</span>
            </h4>
            <p className="text-sm text-gray-600 leading-relaxed">
              Highlights high activity or higher property prices. These zones are considered hotspots, often due to demand or premium listings.
            </p>
          </div>
        </div>
      </div>

      <div className="bg-gray-50 rounded-lg p-4 border-l-4 border-[#0056D2]">
        <h4 className="font-medium text-gray-900 mb-2">In Summary:</h4>
        <ol className="space-y-2 text-sm text-gray-600">
          <li className="flex items-start gap-2">
            <span className="text-[#0056D2] font-semibold mt-0.5">1.</span>
            <span>Red zones represent regions with very high property demand or elevated pricing, indicating premium or competitive markets.</span>
          </li>
          <li className="flex items-start gap-2">
            <span className="text-[#0056D2] font-semibold mt-0.5">2.</span>
            <span>Green zones highlight areas that are more affordable or show lower market activity, making them budget-friendly options.</span>
          </li>
          <li className="flex items-start gap-2">
            <span className="text-[#0056D2] font-semibold mt-0.5">3.</span>
            <span>Yellow/Orange zones fall in the moderate range, reflecting balanced demand and mid-level pricing between the two extremes.</span>
          </li>
        </ol>
      </div>
    </div>
  );
}