import React from 'react';
import { HeatmapMode } from './types';

interface HeatmapLegendProps {
  mode: HeatmapMode;
}

export function HeatmapLegend({ mode }: HeatmapLegendProps) {
  const getLegendConfig = () => {
    switch (mode) {
      case 'density':
        return {
          title: 'Property Density',
          labels: ['Low Density', 'Medium Density', 'High Density'],
          colors: ['#4CAF50', '#FFD700', '#FF4D4D']
        };
      case 'price':
        return {
          title: 'Price Ranges',
          labels: ['Affordable', 'Moderate', 'Premium'],
          colors: ['#4CAF50', '#FFD700', '#FF4D4D']
        };
      case 'price_per_sqft':
        return {
          title: 'Price per Sqft',
          labels: ['Low ₹/sqft', 'Medium ₹/sqft', 'High ₹/sqft'],
          colors: ['#4CAF50', '#FFD700', '#FF4D4D']
        };
      case 'market_velocity':
        return {
          title: 'Market Velocity',
          labels: ['Slow Moving', 'Moderate', 'Fast Moving'],
          colors: ['#FF4D4D', '#FFD700', '#4CAF50']
        };
      default:
        return {
          title: 'Property Density',
          labels: ['Low', 'Medium', 'High'],
          colors: ['#4CAF50', '#FFD700', '#FF4D4D']
        };
    }
  };

  const { title, labels, colors } = getLegendConfig();

  return (
    <div className="bg-white p-3 rounded-lg shadow-sm border" style={{ zIndex: 40, position: 'relative' }}>
      <h4 className="text-sm font-medium mb-2">
        {title}
      </h4>
      <div className="space-y-1">
        {labels.map((label, index) => (
          <div key={label} className="flex items-center gap-2">
            <div
              className="w-4 h-4 rounded"
              style={{ backgroundColor: colors[index] }}
            />
            <span className="text-xs text-gray-600">{label}</span>
          </div>
        ))}
      </div>
    </div>
  );
}