export interface HeatmapPoint {
  lat: number;
  lng: number;
  intensity: number;
  price?: number;
  propertyCount?: number;
  averageDaysOnMarket?: number;
  pricePerSqft?: number;
}

export interface Property {
  id: string | number;
  latitude: number;
  longitude: number;
  sale_price: number;
  monthly_rent: number;
  property_type: string;
  listing_type: string;
  city: string;
}

export type HeatmapMode = 'density' | 'price' | 'price_per_sqft' | 'market_velocity';
