import { Reorder } from 'framer-motion';
import { GripVertical, Clock, Trash2 } from 'lucide-react';
import { ItineraryProperty } from '../../types/itinerary';

interface DraggableListProps {
  properties: ItineraryProperty[];
  onReorder: (properties: ItineraryProperty[]) => void;
  onRemove: (id: string) => void;
  onUpdateTime: (id: string, time: string) => void;
}

export const DraggableList = ({ properties, onReorder, onRemove, onUpdateTime }: DraggableListProps) => {
  return (
    <Reorder.Group axis="y" values={properties} onReorder={onReorder} className="space-y-3">
      {properties.map((property, index) => (
        <Reorder.Item key={property.id} value={property} className="bg-white border border-gray-200 rounded-lg p-4 cursor-move hover:shadow-md transition-shadow">
          <div className="flex items-start gap-4">
            <GripVertical className="w-5 h-5 text-gray-400 mt-1 flex-shrink-0" />
            <div className="flex-shrink-0 w-16 h-16 rounded-lg overflow-hidden">
              <img src={property.photo} alt={property.title} className="w-full h-full object-cover" />
            </div>
            <div className="flex-1 min-w-0">
              <div className="flex items-start justify-between gap-2">
                <div className="flex-1">
                  <div className="flex items-center gap-2">
                    <span className="inline-flex items-center justify-center w-6 h-6 rounded-full bg-blue-600 text-white text-xs font-bold">{index + 1}</span>
                    <h4 className="font-semibold text-gray-900 truncate">{property.title}</h4>
                  </div>
                  <p className="text-sm text-gray-600 mt-1">{property.address}, {property.city}</p>
                </div>
                <button onClick={() => onRemove(property.id)} className="p-1 hover:bg-red-50 rounded text-red-600">
                  <Trash2 className="w-4 h-4" />
                </button>
              </div>
              <div className="flex items-center gap-4 mt-3">
                <div className="flex items-center gap-2">
                  <Clock className="w-4 h-4 text-gray-400" />
                  <select value={property.visitTime} onChange={(e) => onUpdateTime(property.id, e.target.value)} className="text-sm border border-gray-300 rounded px-2 py-1 focus:outline-none focus:ring-2 focus:ring-blue-500">
                    <option value="9:00 AM">9:00 AM</option>
                    <option value="10:00 AM">10:00 AM</option>
                    <option value="11:00 AM">11:00 AM</option>
                    <option value="12:00 PM">12:00 PM</option>
                    <option value="1:00 PM">1:00 PM</option>
                    <option value="2:00 PM">2:00 PM</option>
                    <option value="3:00 PM">3:00 PM</option>
                    <option value="4:00 PM">4:00 PM</option>
                    <option value="5:00 PM">5:00 PM</option>
                  </select>
                </div>
                <span className="text-sm text-gray-600">{property.duration} min visit</span>
              </div>
            </div>
          </div>
        </Reorder.Item>
      ))}
    </Reorder.Group>
  );
};
