interface StatusBadgeProps {
  status: 'draft' | 'scheduled' | 'in-progress' | 'completed' | 'pending' | 'confirmed' | 'cancelled';
  size?: 'sm' | 'md';
}

export const StatusBadge = ({ status, size = 'md' }: StatusBadgeProps) => {
  const styles = {
    draft: 'bg-gray-100 text-gray-700 border-gray-300',
    scheduled: 'bg-blue-100 text-blue-700 border-blue-300',
    'in-progress': 'bg-amber-100 text-amber-700 border-amber-300',
    completed: 'bg-green-100 text-green-700 border-green-300',
    pending: 'bg-yellow-100 text-yellow-700 border-yellow-300',
    confirmed: 'bg-emerald-100 text-emerald-700 border-emerald-300',
    cancelled: 'bg-red-100 text-red-700 border-red-300'
  };

  const sizeClass = size === 'sm' ? 'text-xs px-2 py-0.5' : 'text-sm px-3 py-1';

  return (
    <span className={`inline-flex items-center rounded-full border font-medium ${styles[status]} ${sizeClass}`}>
      {status.replace('-', ' ')}
    </span>
  );
};
