import { MapPin, Clock, Car } from 'lucide-react';
import { ItineraryProperty } from '../../types/itinerary';

interface TimelineViewProps {
  properties: ItineraryProperty[];
  showTravel?: boolean;
}

export const TimelineView = ({ properties, showTravel = true }: TimelineViewProps) => {
  const calculateTravelTime = (from: ItineraryProperty, to: ItineraryProperty) => {
    // Mock calculation - replace with actual distance API
    return Math.floor(Math.random() * 20) + 10;
  };

  return (
    <div className="space-y-4">
      {properties.map((property, index) => (
        <div key={property.id}>
          <div className="flex gap-4">
            <div className="flex flex-col items-center">
              <div className="w-10 h-10 rounded-full bg-blue-600 text-white flex items-center justify-center font-bold text-sm">{index + 1}</div>
              {index < properties.length - 1 && <div className="w-0.5 h-full bg-gray-300 my-2" />}
            </div>
            <div className="flex-1 pb-6">
              <div className="bg-white border border-gray-200 rounded-lg p-4">
                <div className="flex items-start gap-3">
                  <img src={property.photo} alt={property.title} className="w-16 h-16 rounded-lg object-cover" />
                  <div className="flex-1">
                    <h4 className="font-semibold text-gray-900">{property.title}</h4>
                    <div className="flex items-center gap-1 text-sm text-gray-600 mt-1">
                      <MapPin className="w-4 h-4" />
                      <span>{property.address}, {property.city}</span>
                    </div>
                    <div className="flex items-center gap-4 mt-2 text-sm">
                      <div className="flex items-center gap-1 text-blue-600 font-medium">
                        <Clock className="w-4 h-4" />
                        <span>{property.visitTime}</span>
                      </div>
                      <span className="text-gray-600">{property.duration} min</span>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>

          {showTravel && index < properties.length - 1 && (
            <div className="flex gap-4 -mt-2 mb-2">
              <div className="w-10" />
              <div className="flex-1 flex items-center gap-2 text-sm text-gray-600 bg-gray-50 rounded-lg px-4 py-2">
                <Car className="w-4 h-4" />
                <span>{calculateTravelTime(property, properties[index + 1])} min travel</span>
                <span className="text-gray-400">•</span>
                <span>{(Math.random() * 5 + 2).toFixed(1)} km</span>
              </div>
            </div>
          )}
        </div>
      ))}
    </div>
  );
};
