import React from 'react';
import { Shield, CheckCircle, AlertTriangle, FileText } from 'lucide-react';
import { LegalHealthData } from '../../hooks/useLegalHealth';

interface BuyerLegalHealthProps {
  legalHealth: LegalHealthData;
}

export const BuyerLegalHealth: React.FC<BuyerLegalHealthProps> = ({ legalHealth }) => {
  const getStatusIcon = () => {
    switch (legalHealth.legal_status) {
      case 'COMPLETE':
        return <CheckCircle className="w-6 h-6 text-green-600" />;
      case 'INCOMPLETE':
        return <AlertTriangle className="w-6 h-6 text-yellow-600" />;
      default:
        return <Shield className="w-6 h-6 text-gray-400" />;
    }
  };

  const getStatusText = () => {
    return legalHealth.legal_status === 'COMPLETE' 
      ? 'Documents Provided' 
      : 'Documents Pending';
  };

  const getStatusColor = () => {
    switch (legalHealth.legal_status) {
      case 'COMPLETE':
        return 'text-green-800 bg-green-50 border-green-200';
      case 'INCOMPLETE':
        return 'text-yellow-800 bg-yellow-50 border-yellow-200';
      default:
        return 'text-gray-600 bg-gray-50 border-gray-200';
    }
  };

  return (
    <div className="bg-white border border-gray-200 rounded-lg p-6">
      <div className="flex items-center gap-3 mb-4">
        <Shield className="w-5 h-5 text-blue-600" />
        <h3 className="text-lg font-semibold text-gray-900">Legal Status</h3>
      </div>

      {/* Legal Disclaimer */}
      <div className="bg-blue-50 border border-blue-200 rounded-lg p-3 mb-4">
        <p className="text-xs text-blue-800">
          <strong>Disclaimer:</strong> Legal information is provided by the seller for guidance only 
          and does not constitute legal verification or advice.
        </p>
      </div>

      {/* Status Display */}
      <div className={`flex items-center justify-between p-4 rounded-lg border ${getStatusColor()}`}>
        <div className="flex items-center gap-3">
          {getStatusIcon()}
          <div>
            <div className="font-medium">{getStatusText()}</div>
            <div className="text-sm opacity-75">
              {legalHealth.uploaded_documents} of {legalHealth.required_documents} required documents uploaded by seller
            </div>
          </div>
        </div>
        <div className="text-right">
          <div className="text-2xl font-bold">
            {legalHealth.completion_percentage.toFixed(0)}%
          </div>
          <div className="text-xs opacity-75">Complete</div>
        </div>
      </div>

      {/* Progress Bar */}
      <div className="mt-4">
        <div className="w-full bg-gray-200 rounded-full h-2">
          <div
            className={`h-2 rounded-full ${
              legalHealth.completion_percentage === 100 
                ? 'bg-green-500' 
                : legalHealth.completion_percentage > 50 
                ? 'bg-yellow-500' 
                : 'bg-red-500'
            }`}
            style={{ width: `${legalHealth.completion_percentage}%` }}
          />
        </div>
      </div>

      {/* Trust Signal */}
      <div className="mt-4 text-center">
        <p className="text-sm text-gray-600">
          This property has {legalHealth.uploaded_documents > 0 ? 'provided' : 'not provided'} legal documentation for buyer review
        </p>
      </div>
    </div>
  );
};