import React from 'react';
import { BankCard } from './BankCard';

interface Bank {
  id: string;
  name: string;
  logo: string;
  minRate: number;
  maxRate: number;
  processingFee: string;
  features: string[];
}

interface BankSelectorProps {
  banks: Bank[];
  selectedBankId: string | null;
  onBankSelect: (bankId: string) => void;
  loading?: boolean;
}

export const BankSelector: React.FC<BankSelectorProps> = ({
  banks,
  selectedBankId,
  onBankSelect,
  loading = false
}) => {
  if (loading) {
    return (
      <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
        {[1, 2, 3, 4, 5, 6].map((i) => (
          <div key={i} className="p-4 border-2 border-gray-200 rounded-lg animate-pulse">
            <div className="flex items-center gap-3 mb-3">
              <div className="w-10 h-10 bg-gray-200 rounded"></div>
              <div>
                <div className="h-4 bg-gray-200 rounded w-20 mb-1"></div>
                <div className="h-3 bg-gray-200 rounded w-16"></div>
              </div>
            </div>
          </div>
        ))}
      </div>
    );
  }

  return (
    <div className="space-y-6">
      <div className="text-center">
        <h3 className="text-xl font-bold text-gray-900 mb-2">Select Bank</h3>
        <p className="text-gray-600">Choose from India's top banks for the best loan rates</p>
      </div>
      <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
        {banks.map((bank) => (
          <BankCard
            key={bank.id}
            bank={bank}
            isSelected={selectedBankId === bank.id}
            onSelect={onBankSelect}
          />
        ))}
      </div>
    </div>
  );
};