import React from 'react';

interface EMIResult {
  emi: number;
  totalInterest: number;
  totalAmount: number;
  bankName?: string;
  interestRate?: number;
}

interface EMIResultBoxProps {
  result: EMIResult;
  className?: string;
}

export const EMIResultBox: React.FC<EMIResultBoxProps> = ({ result, className = '' }) => {
  return (
    <div className={`bg-gradient-to-r from-blue-50 to-indigo-50 border border-blue-200 rounded-lg p-6 ${className}`}>
      {result.bankName && (
        <div className="mb-4">
          <h3 className="text-lg font-semibold text-blue-800">{result.bankName}</h3>
          {result.interestRate && (
            <p className="text-sm text-blue-600">Interest Rate: {result.interestRate}%</p>
          )}
        </div>
      )}
      
      <div className="grid grid-cols-1 md:grid-cols-3 gap-4">
        <div className="text-center">
          <p className="text-sm text-gray-600 mb-1">Monthly EMI</p>
          <p className="text-2xl font-bold text-blue-600">
            ₹{result.emi.toLocaleString('en-IN')}
          </p>
        </div>
        
        <div className="text-center">
          <p className="text-sm text-gray-600 mb-1">Total Interest</p>
          <p className="text-xl font-semibold text-green-600">
            ₹{result.totalInterest.toLocaleString('en-IN')}
          </p>
        </div>
        
        <div className="text-center">
          <p className="text-sm text-gray-600 mb-1">Total Amount</p>
          <p className="text-xl font-semibold text-purple-600">
            ₹{result.totalAmount.toLocaleString('en-IN')}
          </p>
        </div>
      </div>
    </div>
  );
};