import React from 'react';

interface NegotiationStatusBadgeProps {
  status: string;
}

const NegotiationStatusBadge: React.FC<NegotiationStatusBadgeProps> = ({ status }) => {
  const getStatusColor = (status: string) => {
    switch (status) {
      case 'INITIATED':
        return 'bg-blue-100 text-blue-800';
      case 'OFFER_SENT':
        return 'bg-yellow-100 text-yellow-800';
      case 'COUNTER_SENT':
        return 'bg-orange-100 text-orange-800';
      case 'ACCEPTED':
        return 'bg-green-100 text-green-800';
      case 'REJECTED':
        return 'bg-red-100 text-red-800';
      case 'EXPIRED':
        return 'bg-gray-100 text-gray-800';
      default:
        return 'bg-gray-100 text-gray-800';
    }
  };

  const getStatusText = (status: string) => {
    switch (status) {
      case 'INITIATED':
        return 'Negotiation Started';
      case 'OFFER_SENT':
        return 'Offer Pending';
      case 'COUNTER_SENT':
        return 'Counter Offer Pending';
      case 'ACCEPTED':
        return 'Offer Accepted';
      case 'REJECTED':
        return 'Offer Rejected';
      case 'EXPIRED':
        return 'Offer Expired';
      default:
        return status;
    }
  };

  return (
    <div className="flex items-center justify-between p-4 bg-white rounded-lg shadow-sm border">
      <h2 className="text-xl font-semibold text-gray-900">Negotiation Status</h2>
      <span className={`px-3 py-1 rounded-full text-sm font-medium ${getStatusColor(status)}`}>
        {getStatusText(status)}
      </span>
    </div>
  );
};

export default NegotiationStatusBadge;