import React from 'react';
import { useFormContext } from 'react-hook-form';
import { Input } from '../ui/input';
import { Label } from '../ui/label';
import { Card, CardContent, CardHeader, CardTitle } from '../ui/card';

export default function RERAInput() {
  const { register, watch } = useFormContext();
  const state = watch('state');

  return (
    <Card>
      <CardHeader>
        <CardTitle>RERA Registration</CardTitle>
      </CardHeader>
      <CardContent className="space-y-4">
        <div>
          <Label htmlFor="reraNumber">RERA Registration Number</Label>
          <Input
            id="reraNumber"
            placeholder={`Enter RERA number for ${state || 'your state'}`}
            {...register('reraNumber')}
          />
          <p className="text-sm text-gray-500 mt-1">
            RERA registration is mandatory for properties in most Indian states
          </p>
        </div>
      </CardContent>
    </Card>
  );
}