import React from "react";
import { Button } from "./ui/button";
import { Card, CardContent, CardHeader, CardTitle } from "./ui/card";
import { Building, Store } from "lucide-react";

interface AddPropertyChoiceModalProps {
  onClose: () => void;
  onAddAsset: () => void;
  onListProperty: () => void;
}

const AddPropertyChoiceModal: React.FC<AddPropertyChoiceModalProps> = ({
  onClose,
  onAddAsset,
  onListProperty,
}) => {
  return (
    <div className="space-y-6">
      <div className="text-center">
        <h2 className="text-2xl font-bold text-gray-900 mb-2">Add Property</h2>
        <p className="text-gray-600">
          Choose how you want to add your property
        </p>
      </div>

      <div className="grid grid-cols-1 md:grid-cols-2 gap-6">
        <Card
          className="cursor-pointer hover:shadow-lg transition-shadow border-2 hover:border-blue-300"
          onClick={onAddAsset}
        >
          <CardHeader className="text-center">
            <div className="mx-auto w-16 h-16 bg-blue-100 rounded-full flex items-center justify-center mb-4">
              <Building className="w-8 h-8 text-blue-600" />
            </div>
            <CardTitle className="text-xl">Add to Assets</CardTitle>
          </CardHeader>
          <CardContent className="text-center space-y-3">
            <p className="text-gray-600">
              Add property to your private inventory for future listing
            </p>
            <div className="space-y-2 text-sm text-gray-500">
              <div>✓ Goes through admin approval</div>
              <div>✓ Private until you list it</div>
              <div>✓ Not visible to buyers</div>
              <div>✓ Quick asset management</div>
            </div>
            <Button className="w-full bg-blue-600 hover:bg-blue-700">
              Add to Assets
            </Button>
          </CardContent>
        </Card>

        <Card
          className="cursor-pointer hover:shadow-lg transition-shadow border-2 hover:border-green-300"
          onClick={onListProperty}
        >
          <CardHeader className="text-center">
            <div className="mx-auto w-16 h-16 bg-green-100 rounded-full flex items-center justify-center mb-4">
              <Store className="w-8 h-8 text-green-600" />
            </div>
            <CardTitle className="text-xl">List for Sale</CardTitle>
          </CardHeader>
          <CardContent className="text-center space-y-3">
            <p className="text-gray-600">
              List property directly for public sale
            </p>
            <div className="space-y-2 text-sm text-gray-500">
              <div>✓ Complete property details</div>
              <div>✓ Public after approval</div>
              <div>✓ Visible to buyers</div>
              <div>✓ Full listing features</div>
            </div>
            <Button className="w-full bg-green-600 hover:bg-green-700">
              List Property
            </Button>
          </CardContent>
        </Card>
      </div>

      <div className="flex justify-center">
        <Button variant="outline" onClick={onClose}>
          Cancel
        </Button>
      </div>
    </div>
  );
};

export default AddPropertyChoiceModal;
