import React from 'react';

interface EmptyStateProps {
  onAddProperty: () => void;
  isMobile?: boolean;
}

const EmptyState: React.FC<EmptyStateProps> = ({ onAddProperty, isMobile = false }) => {
  if (isMobile) {
    return (
      <div className="flex flex-col h-screen">
        <header className="flex-shrink-0 bg-background-light dark:bg-background-dark border-b border-primary/20 dark:border-primary/30">
          <div className="flex items-center justify-between p-4 mx-auto max-w-7xl">
            <button className="text-gray-800 dark:text-gray-200">
              <span className="material-symbols-outlined">arrow_back_ios_new</span>
            </button>
            <h1 className="text-lg font-bold text-gray-900 dark:text-white">Listings</h1>
            <div className="w-8"></div>
          </div>
        </header>
        <main className="flex-grow flex flex-col items-center justify-center text-center p-6">
          <div className="max-w-sm w-full">
            <img 
              alt="Illustration of a house" 
              className="w-48 h-48 mx-auto mb-8" 
              src="https://images.unsplash.com/photo-1560518883-ce09059eeffa?ixlib=rb-4.0.3&auto=format&fit=crop&w=400&h=400"
            />
            <h2 className="text-xl font-bold text-gray-900 dark:text-white mb-2">No properties added yet</h2>
            <p className="text-gray-500 dark:text-gray-400 mb-8">Start listing your properties to reach potential buyers.</p>
            <button 
              onClick={onAddProperty}
              className="w-full bg-primary text-white font-bold py-3 px-6 rounded-lg shadow-lg hover:bg-primary/90 focus:outline-none focus:ring-2 focus:ring-primary focus:ring-opacity-50 transition-all duration-300"
            >
              Add Property
            </button>
          </div>
        </main>
      </div>
    );
  }

  return (
    <div className="flex flex-col min-h-screen bg-background-light dark:bg-background-dark font-display text-gray-800 dark:text-gray-200">
      <header className="w-full">
        <div className="container mx-auto px-6 py-4 flex justify-between items-center">
          <div className="flex items-center gap-3">
            <svg className="text-primary" fill="none" height="32" viewBox="0 0 48 48" width="32" xmlns="http://www.w3.org/2000/svg">
              <path d="M24 45.8096C19.6865 45.8096 15.4698 44.5305 11.8832 42.134C8.29667 39.7376 5.50128 36.3314 3.85056 32.3462C2.19985 28.361 1.76794 23.9758 2.60947 19.7452C3.451 15.5145 5.52816 11.6284 8.57829 8.5783C11.6284 5.52817 15.5145 3.45101 19.7452 2.60948C23.9758 1.76795 28.361 2.19986 32.3462 3.85057C36.3314 5.50129 39.7376 8.29668 42.134 11.8833C44.5305 15.4698 45.8096 19.6865 45.8096 24L24 24L24 45.8096Z" fill="currentColor"></path>
            </svg>
            <h1 className="text-xl font-bold text-gray-900 dark:text-white">EstateFlow</h1>
          </div>
          <nav className="hidden md:flex items-center gap-6 text-sm font-medium">
            <a className="text-gray-600 dark:text-gray-300 hover:text-primary dark:hover:text-primary transition-colors" href="#">Buy</a>
            <a className="text-gray-600 dark:text-gray-300 hover:text-primary dark:hover:text-primary transition-colors" href="#">Rent</a>
            <a className="text-gray-600 dark:text-gray-300 hover:text-primary dark:hover:text-primary transition-colors" href="#">Sell</a>
            <a className="text-gray-600 dark:text-gray-300 hover:text-primary dark:hover:text-primary transition-colors" href="#">Mortgage</a>
            <a className="text-gray-900 dark:text-white font-bold" href="#">Manage Properties</a>
          </nav>
          <div className="flex items-center gap-4">
            <button 
              onClick={onAddProperty}
              className="hidden md:inline-flex items-center justify-center bg-primary text-white text-sm font-bold px-4 py-2 rounded-lg hover:bg-primary/90 transition-colors shadow-lg shadow-primary/20"
            >
              Add Property
            </button>
            <div className="w-10 h-10 rounded-full bg-cover bg-center" style={{backgroundImage: "url('https://images.unsplash.com/photo-1472099645785-5658abf4ff4e?ixlib=rb-4.0.3&auto=format&fit=crop&w=40&h=40')"}}></div>
          </div>
        </div>
      </header>
      <main className="flex-grow flex items-center justify-center text-center px-4 sm:px-6 lg:px-8">
        <div className="flex flex-col items-center gap-8 max-w-lg w-full py-16">
          <div className="p-6 bg-primary/10 dark:bg-primary/20 rounded-full">
            <svg className="h-20 w-20 text-primary" fill="none" stroke="currentColor" strokeLinecap="round" strokeLinejoin="round" strokeWidth="1.5" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
              <path d="M3 9l9-7 9 7v11a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2z"></path>
              <polyline points="9 22 9 12 15 12 15 22"></polyline>
            </svg>
          </div>
          <div className="space-y-3">
            <h2 className="text-3xl font-extrabold text-gray-900 dark:text-white">No properties found.</h2>
            <p className="text-lg text-gray-600 dark:text-gray-400">Start by adding your first property.</p>
          </div>
          <button 
            onClick={onAddProperty}
            className="inline-flex items-center justify-center bg-primary text-white text-lg font-bold px-8 py-4 rounded-lg hover:bg-primary/90 transition-all duration-300 ease-in-out shadow-xl shadow-primary/30 transform hover:scale-105 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-primary dark:focus:ring-offset-background-dark"
          >
            Add Property
          </button>
        </div>
      </main>
    </div>
  );
};

export default EmptyState;