import React from 'react';
import { Home, Plus, Search } from 'lucide-react';

interface PremiumEmptyStateProps {
  onAddProperty: () => void;
  isMobile?: boolean;
  type?: 'no-properties' | 'no-results';
}

const PremiumEmptyState: React.FC<PremiumEmptyStateProps> = ({ 
  onAddProperty, 
  isMobile = false,
  type = 'no-properties'
}) => {
  if (isMobile) {
    return (
      <div className="min-h-screen bg-gradient-to-br from-blue-50 to-indigo-100 flex flex-col">
        {/* Header */}
        <div className="bg-white/80 backdrop-blur-sm border-b border-white/20 p-4">
          <div className="flex items-center justify-between">
            <button className="w-10 h-10 rounded-full bg-gray-100 flex items-center justify-center">
              <span className="material-symbols-outlined text-gray-600">arrow_back</span>
            </button>
            <h1 className="text-lg font-bold text-gray-900">My Properties</h1>
            <div className="w-10"></div>
          </div>
        </div>

        {/* Content */}
        <div className="flex-1 flex items-center justify-center p-6">
          <div className="text-center max-w-sm">
            <div className="w-32 h-32 mx-auto mb-8 bg-gradient-to-br from-blue-500 to-indigo-600 rounded-3xl flex items-center justify-center shadow-2xl shadow-blue-500/25">
              {type === 'no-results' ? (
                <Search className="w-16 h-16 text-white" />
              ) : (
                <Home className="w-16 h-16 text-white" />
              )}
            </div>
            
            <h2 className="text-2xl font-bold text-gray-900 mb-3">
              {type === 'no-results' ? 'No Properties Found' : 'Start Your Journey'}
            </h2>
            
            <p className="text-gray-600 mb-8 leading-relaxed">
              {type === 'no-results' 
                ? 'Try adjusting your search filters to find more properties.'
                : 'List your first property and connect with potential buyers in your area.'
              }
            </p>
            
            <button 
              onClick={onAddProperty}
              className="w-full bg-gradient-to-r from-blue-600 to-indigo-600 text-white py-4 rounded-2xl font-semibold text-lg shadow-xl shadow-blue-500/25 hover:shadow-2xl hover:shadow-blue-500/30 transition-all duration-300 flex items-center justify-center gap-3"
            >
              <Plus className="w-6 h-6" />
              Add Your First Property
            </button>
          </div>
        </div>
      </div>
    );
  }

  return (
    <div className="min-h-screen bg-gradient-to-br from-slate-50 via-blue-50 to-indigo-50">
      {/* Header */}
      <div className="bg-white/80 backdrop-blur-sm border-b border-white/20 px-8 py-6">
        <div className="max-w-7xl mx-auto flex items-center justify-between">
          <div className="flex items-center gap-4">
            <div className="w-10 h-10 bg-gradient-to-br from-blue-600 to-indigo-600 rounded-xl flex items-center justify-center">
              <Home className="w-6 h-6 text-white" />
            </div>
            <h1 className="text-2xl font-bold text-gray-900">PropertyHub</h1>
          </div>
          <button 
            onClick={onAddProperty}
            className="bg-gradient-to-r from-blue-600 to-indigo-600 text-white px-6 py-3 rounded-xl font-semibold hover:shadow-lg transition-all duration-300"
          >
            <Plus className="w-5 h-5 inline mr-2" />
            Add Property
          </button>
        </div>
      </div>

      {/* Content */}
      <div className="flex-1 flex items-center justify-center px-8 py-16">
        <div className="text-center max-w-2xl">
          <div className="relative mb-12">
            <div className="w-32 h-32 mx-auto bg-gradient-to-br from-blue-500 to-indigo-600 rounded-2xl flex items-center justify-center shadow-xl shadow-blue-500/25">
              {type === 'no-results' ? (
                <Search className="w-16 h-16 text-white" />
              ) : (
                <Home className="w-16 h-16 text-white" />
              )}
            </div>
          </div>
          
          <h1 className="text-3xl font-bold text-gray-900 mb-4">
            {type === 'no-results' ? 'No Properties Found' : 'Start Building Your Portfolio'}
          </h1>
          
          <p className="text-lg text-gray-600 mb-8 leading-relaxed max-w-lg mx-auto">
            {type === 'no-results' 
              ? 'Try adjusting your search filters or add new properties to get started.'
              : 'List your first property and start connecting with potential buyers in your area.'
            }
          </p>
          
          <div className="flex flex-col sm:flex-row gap-4 justify-center">
            <button 
              onClick={onAddProperty}
              className="bg-gradient-to-r from-blue-600 to-indigo-600 text-white px-8 py-4 rounded-2xl font-semibold text-lg shadow-xl shadow-blue-500/25 hover:shadow-2xl hover:shadow-blue-500/30 transition-all duration-300 flex items-center justify-center gap-3"
            >
              <Plus className="w-6 h-6" />
              {type === 'no-results' ? 'Add New Property' : 'List Your First Property'}
            </button>
            
            {type === 'no-results' && (
              <button className="border-2 border-gray-300 text-gray-700 px-8 py-4 rounded-2xl font-semibold text-lg hover:border-gray-400 hover:bg-gray-50 transition-all duration-300">
                Clear Filters
              </button>
            )}
          </div>
        </div>
      </div>
    </div>
  );
};

export default PremiumEmptyState;