import React, { useState } from 'react';
import { motion } from 'framer-motion';

interface SidebarProps {
  isExpanded: boolean;
  onToggle: () => void;
}

const menuItems = [
  { name: 'Dashboard', icon: (
    <svg className="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
      <path strokeLinecap="round" strokeLinejoin="round" strokeWidth={2} d="M3 12l2-2m0 0l7-7 7 7M13 5v6h6" />
    </svg>
  ) },
  { name: 'Properties', icon: (
    <svg className="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
      <path strokeLinecap="round" strokeLinejoin="round" strokeWidth={2} d="M3 10h18M3 14h18M5 6h14v12H5z" />
    </svg>
  ) },
  { name: 'Campaigns', icon: (
    <svg className="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
      <path strokeLinecap="round" strokeLinejoin="round" strokeWidth={2} d="M11 5.882V19.24a1.76 1.76 0 01-3.417.592l-2.147-6.15M18 13a3 3 0 100-6M5.436 13.683A4.001 4.001 0 017 6h1.832c4.1 0 7.625-1.234 9.168-3v14c-1.543-1.766-5.067-3-9.168-3H7a3.988 3.988 0 01-1.564-.317z" />
    </svg>
  ) },
  { name: 'Property Trends', icon: (
    <svg className="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
      <path strokeLinecap="round" strokeLinejoin="round" strokeWidth={2} d="M11 17l-4-4-4 4m8-8l4 4 4-4" />
    </svg>
  ) },
  { name: 'My Biddings', icon: (
    <svg className="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
      <path strokeLinecap="round" strokeLinejoin="round" strokeWidth={2} d="M12 8v4l3 3" />
    </svg>
  ) },
  { name: 'Booking Management', icon: (
    <svg className="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
      <rect x="3" y="4" width="18" height="16" rx="2" ry="2" />
      <line x1="16" y1="2" x2="16" y2="6" />
      <line x1="8" y1="2" x2="8" y2="6" />
      <line x1="3" y1="10" x2="21" y2="10" />
    </svg>
  ) },
  { name: 'Legal & Loan', icon: (
    <svg className="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
      <path strokeLinecap="round" strokeLinejoin="round" strokeWidth={2} d="M12 8v4l3 3" />
    </svg>
  ) },
  { name: 'Legal Health Reports', icon: (
    <svg className="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
      <path strokeLinecap="round" strokeLinejoin="round" strokeWidth={2} d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z" />
    </svg>
  ) },
  { name: 'Schedules', icon: (
    <svg className="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
      <rect x="3" y="4" width="18" height="16" rx="2" ry="2" />
      <line x1="16" y1="2" x2="16" y2="6" />
      <line x1="8" y1="2" x2="8" y2="6" />
      <line x1="3" y1="10" x2="21" y2="10" />
    </svg>
  ) },
  { name: 'Reports', icon: (
    <svg className="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
      <path strokeLinecap="round" strokeLinejoin="round" strokeWidth={2} d="M9 17v-6h6v6m-6 0h6" />
    </svg>
  ) },
];

const Sidebar: React.FC<SidebarProps> = ({ isExpanded, onToggle }) => {
  const [activeIndex, setActiveIndex] = useState(0);

  return (
    <motion.div
      initial={false}
      animate={{ width: isExpanded ? 280 : 72 }}
      transition={{ duration: 0.3, ease: 'easeInOut' }}
      className="fixed left-0 top-0 h-full bg-white border-r border-gray-200 z-40 flex flex-col"
    >
      {/* Logo Section */}
      <div className="p-4 border-b border-gray-200">
        <button
          onClick={() => {
            window.location.href = '/';
          }}
          className="flex items-center w-full hover:bg-gray-50 rounded-lg p-2 transition-colors cursor-pointer"
        >
          <div className="w-8 h-8 bg-primary rounded-lg flex items-center justify-center text-white font-bold text-sm">
            NAL
          </div>
          {isExpanded && (
            <motion.div
              initial={{ opacity: 0 }}
              animate={{ opacity: 1 }}
              exit={{ opacity: 0 }}
              transition={{ delay: 0.1 }}
              className="ml-3 flex items-center justify-between flex-1"
            >
              <div>
                <div className="font-semibold text-text-primary">New Age Land</div>
                <div className="text-xs text-gray-600">Seller Panel</div>
              </div>
            </motion.div>
          )}
        </button>
        {isExpanded && (
          <button
            onClick={onToggle}
            className="mt-2 w-full flex justify-end"
          >
            <svg
              className="w-4 h-4 text-text-muted"
              fill="none"
              stroke="currentColor"
              viewBox="0 0 24 24"
            >
              <path strokeLinecap="round" strokeLinejoin="round" strokeWidth={2} d="M9 5l7 7-7 7" />
            </svg>
          </button>
        )}
      </div>

      {/* Navigation */}
      <nav className="flex-1 p-4">
        <div className="space-y-2">
          {menuItems.map((item, index) => {
            const isActive = index === activeIndex;
            return (
              <button
                key={item.name}
                onClick={() => setActiveIndex(index)}
                className={`flex items-center w-full p-3 rounded-lg transition-colors ${
                  isActive
                    ? 'bg-primary text-white border-r-4 border-blue-600'
                    : 'text-gray-700 hover:bg-primary/10 hover:text-primary'
                }`}
              >
                {item.icon}
                {isExpanded && <span className="ml-3 font-medium">{item.name}</span>}
              </button>
            );
          })}
        </div>
      </nav>
    </motion.div>
  );
};

export default Sidebar;
