import { useState, createContext, useContext } from "react";
import { Sidebar } from "./sidebar";
import { SellerDashboardHeader } from "./SellerDashboardHeader";

interface LayoutProps {
  children: React.ReactNode;
}

const SidebarContext = createContext({ isCollapsed: false });

export function Layout({ children }: LayoutProps) {
  const [isCollapsed, setIsCollapsed] = useState(false);

  return (
    <SidebarContext.Provider value={{ isCollapsed }}>
      <div className="min-h-screen bg-gray-50">
        <Sidebar isCollapsed={isCollapsed} setIsCollapsed={setIsCollapsed} />
        <div className={`min-h-screen bg-gray-50 transition-all duration-300 ${
          isCollapsed ? 'ml-20' : 'ml-64'
        }`} style={{ marginLeft: isCollapsed ? '80px' : '256px' }}>
          <SellerDashboardHeader />
          <main className="p-8">
            {children}
          </main>
        </div>
      </div>
    </SidebarContext.Provider>
  );
}

export const useSidebar = () => useContext(SidebarContext);