import React, { createContext, useContext, useState, ReactNode } from 'react';

type Property = {
  id: string;
  title: string;
  // Add other property fields as needed
};

type AppContextType = {
  properties: Property[];
  updateProperty: (id: string, updatedData: Partial<Property>) => void;
};

const AppContext = createContext<AppContextType | undefined>(undefined);

export const AppProvider: React.FC<{ children: ReactNode }> = ({ children }) => {
  const [properties, setProperties] = useState<Property[]>([]);

  const updateProperty = (id: string, updatedData: Partial<Property>) => {
    setProperties((prev) =>
      prev.map((property) =>
        property.id === id ? { ...property, ...updatedData } : property
      )
    );
  };

  return (
    <AppContext.Provider value={{ properties, updateProperty }}>
      {children}
    </AppContext.Provider>
  );
};

export function useApp(): AppContextType {
  const context = useContext(AppContext);
  if (!context) {
    throw new Error('useApp must be used within an AppProvider');
  }
  return context;
}
