import React from 'react';
import { useParams, useNavigate } from 'react-router-dom';

const BiddingManagement: React.FC = () => {
  console.log('BiddingManagement component loaded');
  const { id } = useParams<{ id: string }>();
  const navigate = useNavigate();
  
  // Always show content for testing
  return (
    <div className="p-6">
      <h1 className="text-2xl font-bold mb-4">Bidding Management Test</h1>
      <p>Property ID from URL: {id}</p>
      <button
        onClick={() => navigate('../properties')}
        className="px-4 py-2 bg-blue-600 text-white rounded-lg hover:bg-blue-700 mt-4"
      >
        Back to Properties
      </button>
    </div>
  );


};

export default BiddingManagement;