import { ListingForm } from "../../../../pages/ListingForm";
import { useSearchParams } from "react-router-dom";

export default function ListPropertyPage() {
  const [searchParams] = useSearchParams();
  const propertyType = searchParams.get('type'); // 'asset' or 'listing'
  
  return (
    <div className="flex-1 overflow-y-auto p-6 space-y-6">
      {/* Header */}
      <div className="mb-8">
        <h1 className="text-3xl font-bold text-foreground">
          {propertyType === 'asset' ? 'Add Property to Assets' : 'Add New Property'}
        </h1>
        <p className="text-muted-foreground mt-1">
          {propertyType === 'asset' 
            ? 'Add property to your asset portfolio (no listing required)' 
            : 'Fill in the details to list your property'}
        </p>
      </div>
      {/* Listing Form */}
      <ListingForm />
    </div>
  );
}