import { Card, CardContent, CardHeader, CardTitle } from "../components/ui/card";
import { Badge } from "../components/ui/badge";
import { Button } from "../components/ui/button";
import { TrendingUp, TrendingDown, IndianRupee, PieChart, BarChart3, Calendar, Target, Users } from "lucide-react";

export default function RevenueAnalytics() {
  const revenueData = {
    totalRevenue: 2450000,
    monthlyGrowth: 12.5,
    avgDealSize: 485000,
    conversionRate: 3.2,
    topPerformingProperty: "Luxury Downtown Penthouse",
    totalDeals: 18,
    pipeline: 1850000
  };

  return (
    <div className="flex-1 space-y-6 p-4 md:p-8 pt-6">
      <div className="flex items-center justify-between">
        <div>
          <h1 className="text-3xl font-bold tracking-tight">Revenue Analytics</h1>
          <p className="text-muted-foreground">Track your sales performance and revenue insights</p>
        </div>
        <Button>
          <BarChart3 className="mr-2 h-4 w-4" />
          Export Report
        </Button>
      </div>

      {/* Revenue Metrics */}
      <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6">
        <Card className="bg-gradient-to-br from-green-50 to-green-100 border-green-200">
          <CardContent className="p-6">
            <div className="flex items-center justify-between">
              <div>
                <p className="text-sm text-green-700 font-medium">Total Revenue</p>
                <p className="text-3xl font-bold text-green-800">₹{(revenueData.totalRevenue / 100000).toFixed(1)}L</p>
                <div className="flex items-center mt-2">
                  <TrendingUp className="w-4 h-4 text-green-600 mr-1" />
                  <span className="text-sm text-green-600 font-medium">+{revenueData.monthlyGrowth}%</span>
                </div>
              </div>
              <IndianRupee className="w-8 h-8 text-green-600" />
            </div>
          </CardContent>
        </Card>

        <Card className="bg-gradient-to-br from-blue-50 to-blue-100 border-blue-200">
          <CardContent className="p-6">
            <div className="flex items-center justify-between">
              <div>
                <p className="text-sm text-blue-700 font-medium">Avg Deal Size</p>
                <p className="text-3xl font-bold text-blue-800">₹{(revenueData.avgDealSize / 100000).toFixed(1)}L</p>
                <p className="text-sm text-blue-600 mt-2">Per transaction</p>
              </div>
              <Target className="w-8 h-8 text-blue-600" />
            </div>
          </CardContent>
        </Card>

        <Card className="bg-gradient-to-br from-purple-50 to-purple-100 border-purple-200">
          <CardContent className="p-6">
            <div className="flex items-center justify-between">
              <div>
                <p className="text-sm text-purple-700 font-medium">Conversion Rate</p>
                <p className="text-3xl font-bold text-purple-800">{revenueData.conversionRate}%</p>
                <p className="text-sm text-purple-600 mt-2">Lead to sale</p>
              </div>
              <PieChart className="w-8 h-8 text-purple-600" />
            </div>
          </CardContent>
        </Card>

        <Card className="bg-gradient-to-br from-orange-50 to-orange-100 border-orange-200">
          <CardContent className="p-6">
            <div className="flex items-center justify-between">
              <div>
                <p className="text-sm text-orange-700 font-medium">Pipeline Value</p>
                <p className="text-3xl font-bold text-orange-800">₹{(revenueData.pipeline / 100000).toFixed(0)}L</p>
                <p className="text-sm text-orange-600 mt-2">Potential deals</p>
              </div>
              <Users className="w-8 h-8 text-orange-600" />
            </div>
          </CardContent>
        </Card>
      </div>

      {/* Performance Insights */}
      <div className="grid grid-cols-1 lg:grid-cols-2 gap-6">
        <Card>
          <CardHeader>
            <CardTitle>Top Performing Properties</CardTitle>
          </CardHeader>
          <CardContent>
            <div className="space-y-4">
              {[
                { name: "Luxury Downtown Penthouse", revenue: 8500000, deals: 2, growth: 15 },
                { name: "Modern Suburban Villa", revenue: 7200000, deals: 3, growth: 8 },
                { name: "Beachfront Condo", revenue: 6800000, deals: 4, growth: -2 },
                { name: "City Center Apartment", revenue: 2000000, deals: 9, growth: 22 }
              ].map((property, index) => (
                <div key={index} className="flex items-center justify-between p-3 bg-muted/30 rounded-lg">
                  <div className="flex-1">
                    <h4 className="font-medium">{property.name}</h4>
                    <p className="text-sm text-muted-foreground">{property.deals} deals closed</p>
                  </div>
                  <div className="text-right">
                    <p className="font-semibold">₹{(property.revenue / 100000).toFixed(1)}L</p>
                    <div className="flex items-center">
                      {property.growth > 0 ? (
                        <TrendingUp className="w-3 h-3 text-green-600 mr-1" />
                      ) : (
                        <TrendingDown className="w-3 h-3 text-red-600 mr-1" />
                      )}
                      <span className={`text-xs ${property.growth > 0 ? 'text-green-600' : 'text-red-600'}`}>
                        {property.growth > 0 ? '+' : ''}{property.growth}%
                      </span>
                    </div>
                  </div>
                </div>
              ))}
            </div>
          </CardContent>
        </Card>

        <Card>
          <CardHeader>
            <CardTitle>Monthly Revenue Trend</CardTitle>
          </CardHeader>
          <CardContent>
            <div className="space-y-4">
              {[
                { month: "January", revenue: 4200000, deals: 3 },
                { month: "February", revenue: 3800000, deals: 2 },
                { month: "March", revenue: 6500000, deals: 4 },
                { month: "April", revenue: 5200000, deals: 3 },
                { month: "May", revenue: 7800000, deals: 5 },
                { month: "June", revenue: 8900000, deals: 6 }
              ].map((month, index) => (
                <div key={index} className="flex items-center justify-between">
                  <div className="flex items-center gap-3">
                    <Calendar className="w-4 h-4 text-muted-foreground" />
                    <span className="font-medium">{month.month}</span>
                  </div>
                  <div className="text-right">
                    <p className="font-semibold">₹{(month.revenue / 100000).toFixed(1)}L</p>
                    <p className="text-xs text-muted-foreground">{month.deals} deals</p>
                  </div>
                </div>
              ))}
            </div>
          </CardContent>
        </Card>
      </div>

      {/* Revenue Breakdown */}
      <Card>
        <CardHeader>
          <CardTitle>Revenue Breakdown by Property Type</CardTitle>
        </CardHeader>
        <CardContent>
          <div className="grid grid-cols-1 md:grid-cols-3 gap-6">
            {[
              { type: "Luxury Properties", revenue: 12000000, percentage: 49, color: "bg-blue-500" },
              { type: "Mid-Range Properties", revenue: 8500000, percentage: 35, color: "bg-green-500" },
              { type: "Budget Properties", revenue: 4000000, percentage: 16, color: "bg-orange-500" }
            ].map((category, index) => (
              <div key={index} className="text-center">
                <div className={`w-16 h-16 ${category.color} rounded-full mx-auto mb-3 flex items-center justify-center`}>
                  <span className="text-white font-bold text-lg">{category.percentage}%</span>
                </div>
                <h4 className="font-medium mb-1">{category.type}</h4>
                <p className="text-2xl font-bold">₹{(category.revenue / 10000000).toFixed(1)}Cr</p>
              </div>
            ))}
          </div>
        </CardContent>
      </Card>
    </div>
  );
}