import Dashboard from "./pages/dashboard";
import PremiumPropertyDashboard from "./pages/PremiumPropertyDashboard";
import ListPropertyPage from "./pages/ListPropertyPage";
import { ListingForm } from "../../../pages/ListingForm";
import leads from "./pages/leads";
import bookings from "./pages/bookings";
import BookingScheduling from "./pages/BookingScheduling";
import MarketingTools from "./pages/MarketingTools";
import documents from "./pages/documents";
import LegalDocuments from "./pages/LegalDocuments";
import campaigns from "./pages/campaigns";
import analytics from "./pages/analytics";
import valuation from "./pages/valuation";
import PriceIntelligence from "./pages/price-intelligence";
import MarketIntelligence from "./pages/MarketIntelligence";
import AIInsights from "./pages/AIInsights";
import AuctionHold from "./pages/auction-hold";
import UrgentVisits from "./pages/urgent-visits";
import AuctionBidding from "./pages/auction-bidding";
import BiddingManagement from "./pages/BiddingManagement";
import AuctionSession from "./pages/AuctionSession";
import BiddingProperties from "./pages/BiddingProperties";
import promote from "./pages/promote";
import Financials from "./pages/financials";
import Settings from "./pages/settings";
import Hosting from "./pages/hosting";
import EditProperty from "./pages/EditProperty";
import PropertyDetails from "./pages/PropertyDetails";
import Reports from "./pages/Reports";
import NotFound from "./pages/not-found";
import Approvals from "./pages/approvals";
import { DigitalVault } from "../../../pages/services";
import { PricePrediction } from "../../../pages/price-prediction/PricePrediction";
import { ContractManagement } from "../../../pages/services/ContractManagement";
import Negotiations from "./pages/negotiations";
import NegotiationDetail from "./pages/negotiation-detail";
import NRIAssistance from "./pages/nri-assistance";
import { SellerPropertyAnalytics } from "../SellerPropertyAnalytics";
import LegalHealthReports from "./pages/LegalHealthReports";
import RequestDetails from "./pages/RequestDetails";
import AssetDashboard from "./pages/AssetDashboard";
import AssetDetails from "./pages/AssetDetails";
import DynamicPricing from "./pages/dynamic-pricing";

export const routes = [
  { path: "/", component: Dashboard },
  { path: "/properties", component: PremiumPropertyDashboard },
  { path: "/assets", component: AssetDashboard },
  { path: "/assets/:id", component: AssetDetails },
  { path: "/property-analytics", component: SellerPropertyAnalytics },
  { path: "/add-property", component: ListPropertyPage },
  { path: "/list-property", component: ListPropertyPage },
  { path: "/leads", component: leads },
  { path: "/bookings", component: bookings },
  { path: "/negotiations", component: Negotiations },
  { path: "/negotiation/:id", component: NegotiationDetail },
  { path: "/reports", component: Reports },
  { path: "/approvals", component: Approvals },
  { path: "/booking-scheduling", component: BookingScheduling },
  { path: "/marketing-tools", component: MarketingTools },
  { path: "/documents", component: documents },
  { path: "/legal-documents", component: LegalDocuments },
  { path: "/campaigns", component: campaigns },
  { path: "/analytics", component: analytics },
  { path: "/valuation", component: valuation },
  { path: "/price-intelligence", component: PriceIntelligence },
  { path: "/dynamic-pricing", component: DynamicPricing },
  { path: "/market-intelligence", component: MarketIntelligence },
  { path: "/ai-insights", component: AIInsights },
  { path: "/auction-hold", component: AuctionHold },
  { path: "/urgent-visits", component: UrgentVisits },
  { path: "/auction-bidding", component: AuctionBidding },
  { path: "/auction-session/:propertyId/:sessionId", component: AuctionSession },
  { path: "/bidding-management", component: BiddingManagement },
  { path: "/bidding-properties", component: BiddingProperties },
  { path: "/promote", component: promote },
  { path: "/financials", component: Financials },
  { path: "/contracts", component: ContractManagement },
  { path: "/nri-assistance", component: NRIAssistance },
  { path: "/settings", component: Settings },
  { path: "/hosting", component: Hosting },
  { path: "/edit-property", component: EditProperty },
  { path: "/property-details", component: PropertyDetails },
  { path: "/digital-vault", component: () => DigitalVault({ showHero: false }) },
  { path: "/price-prediction", component: PricePrediction },
  { path: "/legal-health-reports", component: LegalHealthReports },
  { path: "/legal-health-requests/:id", component: RequestDetails },
  { path: "*", component: NotFound },
];
