export type FormStep = 'details' | 'documents' | 'intent' | 'location' | 'media' | 'review';

export interface FormStepProps {
  onNext?: () => void;
  onPrev?: () => void;
  isFirst?: boolean;
  isLast?: boolean;
  isEdit?: boolean;
}

export interface Property {
  id: string;
  title: string;
  type: string;
  bhk?: string;
  address: string;
  city: string;
  state: string;
  pincode: string;
  landmark?: string;
  area: number;
  price: number;
  listingIntent: string;
  listing_type?: string | null; // Asset Management: null = asset, non-null = listed
  status: string;
  isasset?: boolean; // Asset Management field
  listing_status?: string; // Asset Management field
  amenities: string[];
  customAmenities: string[];
  virtualTour?: string;
  sellerType?: string;
  biddingEnabled?: boolean;
  coordinates?: { lat: number; lng: number };
  views: number;
  inquiries: number;
  createdAt: string;
  updatedAt: string;
  description?: string;
  images?: (string | { url: string; image?: string; thumbnail_url?: string })[];
  videos?: (string | { url: string; thumbnail_url?: string; title?: string })[];
  imageCategories?: Record<string, unknown>;
  // Additional property details
  bathrooms?: number;
  facing?: string;
  furnishing?: string;
  propertyAge?: string;
  possessionStatus?: string;
  nearbyPlaces?: string[];
  propertyHighlights?: string[];
  // Legal Health
  legalHealth?: {
    legal_status: 'NOT_STARTED' | 'INCOMPLETE' | 'COMPLETE';
    risk_level: 'LOW' | 'MEDIUM' | 'HIGH';
    completion_percentage: number;
    uploaded_documents: number;
    required_documents: number;
  };
}

export interface PropertyFormData {
  title: string;
  type: 'apartment' | 'house' | 'villa' | 'commercial';
  bhk?: string;
  address: string;
  city: string;
  state: string;
  pincode: string;
  landmark?: string;
  area: number;
  price: number;
  listingIntent: 'sale' | 'rent' | 'urgent-sale' | 'bidding';
  amenities: string[];
  customAmenities: string[];
  sellerType: 'owner' | 'agent' | 'company';
  description: string;
  images: File[];
  videos: File[];
  virtualTour?: string;
  imageCategories: Record<string, File[]>;
  documents: File[];
  requiredDocuments: File[];
  projectBrochure?: File;
  biddingEnabled: boolean;
  startingBidPrice?: number;
  reservePrice?: number;
  minimumIncrement?: number;
  termsAccepted: boolean;
  coordinates?: { lat: number; lng: number };
  // Seller details
  fullname?: string;
  email?: string;
  property_manager_contact?: string;
}