export interface BiddingSession {
  id: string;
  propertyId: string;
  startTime: string;
  endTime: string;
  status: 'active' | 'ended' | 'upcoming';
  startingPrice: number;
  reservePrice?: number;
  bidIncrement: number;
  currentHighestBid?: number;
  totalBids: number;
  participants: number;
}

export interface Bid {
  id: string;
  sessionId: string;
  bidderId: string;
  amount: number;
  timestamp: string;
  status: 'active' | 'outbid' | 'winning';
}

export interface Bidder {
  id: string;
  name: string;
  email: string;
  phone: string;
  verified: boolean;
  totalBids: number;
  joinedAt: string;
}