interface PromotionData {
  property_id: string;
  type: "featured" | "premium" | "urgent";
  platforms: string[];
}

interface PromotionResult {
  promotion: {
    id: string;
    start_date: string;
    end_date: string;
    status: string;
  };
}

export const createPromotion = async (data: PromotionData): Promise<PromotionResult> => {
  // Mock API call for promotion creation
  return new Promise((resolve) => {
    setTimeout(() => {
      const startDate = new Date();
      const endDate = new Date();
      endDate.setDate(startDate.getDate() + 30); // 30 days promotion

      resolve({
        promotion: {
          id: `promo_${Date.now()}`,
          start_date: startDate.toISOString(),
          end_date: endDate.toISOString(),
          status: 'active'
        }
      });
    }, 1000);
  });
};

export const getPromotions = async () => {
  // Mock API call to get promotions
  return new Promise((resolve) => {
    setTimeout(() => {
      resolve([]);
    }, 500);
  });
};

export const updatePromotion = async (id: string, data: Partial<PromotionData>) => {
  // Mock API call to update promotion
  return new Promise((resolve) => {
    setTimeout(() => {
      resolve({ success: true });
    }, 500);
  });
};

export const deletePromotion = async (id: string) => {
  // Mock API call to delete promotion
  return new Promise((resolve) => {
    setTimeout(() => {
      resolve({ success: true });
    }, 500);
  });
};