export interface SystemMetric {
  id: number;
  metric_type: 'cpu_usage' | 'memory_usage' | 'disk_usage' | 'network_io' | 'database_connections' | 'response_time' | 'error_rate' | 'uptime';
  value: number;
  unit: string;
  timestamp: string;
  server_name: string;
}

export interface SystemAlert {
  id: number;
  title: string;
  message: string;
  severity: 'info' | 'warning' | 'error' | 'critical';
  status: 'active' | 'acknowledged' | 'resolved';
  metric_type?: string;
  threshold_value?: number;
  current_value?: number;
  created_at: string;
  resolved_at?: string;
  acknowledged_by?: string;
}

export interface SystemLog {
  id: number;
  level: 'debug' | 'info' | 'warning' | 'error' | 'critical';
  message: string;
  source: string;
  user_id?: number;
  ip_address?: string;
  request_path?: string;
  timestamp: string;
}

export interface HealthCheck {
  service_name: string;
  status: 'healthy' | 'degraded' | 'unhealthy';
  response_time_ms?: number;
  last_check: string;
  error_message?: string;
}

export interface SystemHealth {
  overall_health: 'healthy' | 'degraded' | 'unhealthy';
  health_score: number;
  metrics: {
    cpu_usage: number;
    memory_usage: number;
    disk_usage: number;
    database_response_time: number;
  };
  active_alerts: number;
  last_updated: string;
}

export interface DashboardStats {
  system_metrics: {
    cpu_usage: number;
    memory_usage: number;
    disk_usage: number;
  };
  alert_counts: {
    critical: number;
    error: number;
    warning: number;
    info: number;
  };
  log_counts: {
    error: number;
    warning: number;
    info: number;
  };
  service_health: {
    healthy: number;
    total: number;
    health_percentage: number;
  };
  total_active_alerts: number;
  total_logs_24h: number;
}

export interface MetricHistoryPoint {
  timestamp: string;
  value: number;
  unit: string;
}

export interface ApiResponse<T> {
  status: 'success' | 'error';
  data?: T;
  message?: string;
  pagination?: any;
}