import { useState } from "react";
import { Button } from "../ui/button";
import { Card } from "../ui/card";

export const CheckInPage = () => {
  const [checkedIn, setCheckedIn] = useState(false);

  return (
    <div className="container mx-auto p-6">
      <Card className="p-6">
        <h1 className="text-2xl font-bold mb-4">Property Visit Check-In</h1>
        <p className="text-gray-600 mb-6">Check in to your scheduled property visit</p>
        <Button onClick={() => setCheckedIn(!checkedIn)}>
          {checkedIn ? "Checked In" : "Check In"}
        </Button>
      </Card>
    </div>
  );
};
