import React, { createContext, useContext, useState } from 'react';

interface LoadingContextType {
  isLoginLoading: boolean;
  setLoginLoading: (loading: boolean) => void;
}

const LoadingContext = createContext<LoadingContextType | undefined>(undefined);

export const LoadingProvider: React.FC<{ children: React.ReactNode }> = ({ children }) => {
  const [isLoginLoading, setIsLoginLoading] = useState(false);

  const setLoginLoading = (loading: boolean) => {
    setIsLoginLoading(loading);
  };

  return (
    <LoadingContext.Provider value={{ isLoginLoading, setLoginLoading }}>
      {children}
    </LoadingContext.Provider>
  );
};

export const useLoading = () => {
  const context = useContext(LoadingContext);
  if (context === undefined) {
    console.warn('useLoading must be used within a LoadingProvider. Using default values.');
    return {
      isLoginLoading: false,
      setLoginLoading: () => {}
    };
  }
  return context;
};