import { useEffect } from 'react';
import { UseFormWatch, UseFormSetValue } from 'react-hook-form';
import { ListingFormData } from '../types/listing';
import { api } from '../utils/api';

export const useFormDraft = (
  watch: UseFormWatch<ListingFormData>,
  setValue: UseFormSetValue<ListingFormData>
) => {
  // Load draft on mount
  useEffect(() => {
    const draft = api.loadDraft();
    if (draft) {
      Object.keys(draft).forEach((key) => {
        const value = draft[key as keyof ListingFormData];
        if (value !== undefined) {
          setValue(key as keyof ListingFormData, value as any);
        }
      });
    }
  }, [setValue]);

  // Auto-save draft on form changes
  useEffect(() => {
    const subscription = watch((data) => {
      const cleanData = Object.fromEntries(
        Object.entries(data).filter(([_, value]) => value !== undefined)
      ) as Partial<ListingFormData>;
      api.saveDraft(cleanData);
    });
    return () => subscription.unsubscribe();
  }, [watch]);

  const clearDraft = () => {
    api.clearDraft();
  };

  return { clearDraft };
};