import { useState } from 'react';
import { uploadPropertyImages, uploadPropertyVideos, uploadPropertyDocuments } from '../api/mediaUpload';

export const useMediaUpload = () => {
  const [uploading, setUploading] = useState(false);
  const [progress, setProgress] = useState(0);

  const uploadImages = async (propertyId: string, images: File[]) => {
    setUploading(true);
    setProgress(0);
    
    try {
      const result = await uploadPropertyImages(propertyId, images);
      setProgress(100);
      return result;
    } finally {
      setUploading(false);
      setProgress(0);
    }
  };

  const uploadVideos = async (propertyId: string, videos: File[]) => {
    setUploading(true);
    setProgress(0);
    
    try {
      const result = await uploadPropertyVideos(propertyId, videos);
      setProgress(100);
      return result;
    } finally {
      setUploading(false);
      setProgress(0);
    }
  };

  const uploadDocuments = async (propertyId: string, documents: File[], types: string[]) => {
    setUploading(true);
    setProgress(0);
    
    try {
      const result = await uploadPropertyDocuments(propertyId, documents, types);
      setProgress(100);
      return result;
    } finally {
      setUploading(false);
      setProgress(0);
    }
  };

  return {
    uploading,
    progress,
    uploadImages,
    uploadVideos,
    uploadDocuments,
  };
};