
import { useState } from 'react';
import { adminService } from '../api/adminService';

export const useOAuthFlow = (providerId: string) => {
    const [loading, setLoading] = useState(false);
    const [error, setError] = useState<string | null>(null);

    const initiateOAuth = async () => {
        setLoading(true);
        setError(null);
        try {
            // Call Real Backend Endpoint
            const res = await adminService.connectors.getOAuthUrl(providerId);
            return res.data.url;

        } catch (err: any) {
            setError(err.message || 'Failed to initiate OAuth');
            return null;
        } finally {
            setLoading(false);
        }
    };

    return { initiateOAuth, loading, error };
};
